#include "mbed.h"
#include "BD6212.h"

BD6212::BD6212(PinName fwd, PinName rev) : _fwd(fwd), _rev(rev){
    _fwd.period_us(20);
    _rev.period_us(20);
    _fwd = 0.0f;
    _rev = 0.0f;
    
    bspeed = 0.0f;
}

void BD6212::speed(float speed){
    _fwd.period_us(20);
    _rev.period_us(20);
    if(speed != bspeed){
        if(speed > 0.0f){
            _fwd = speed;
            _rev = 0.0f;
        }else if(speed < 0.0f){
            _fwd = 0.0f;
            _rev = -speed;
        }else{
            _fwd = 1.0f;
            _rev = 1.0f;
        }
        bspeed = speed;
    }
}

void BD6212::coast(void){
    _fwd.period_us(20);
    _rev.period_us(20);
    _fwd = 0.0f;
    _rev = 0.0f;
}
