/* mbed CustomExplorerRobot Library
 *
 * CustomExplorerRobot.h
 *
 * Copyright (c) 2016 ??????
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "mbed.h"
#include "CustomExplorerRobot.h"

CustomExplorerRobot::CustomExplorerRobot() : _right(PC_7, PC_6), _left(PC_8, PC_9), _redled(PC_5), _blueled(PA_12), _buzzer(PA_11) {
    _right = 0.0f;
    _left = 0.0f;
    _redled = 1.0f;
    _blueled = 1.0f;
    _buzzer = 0.0f;
}
    
void CustomExplorerRobot::left_motor(float speed){
    _left = speed;
}
    
void CustomExplorerRobot::right_motor(float speed){
    _right = speed;
}
    
void CustomExplorerRobot::forward(float speed){
    _left = speed;
    _right = speed;
}
    
void CustomExplorerRobot::backward(float speed){
    _left = -speed;
    _right = -speed;
}
    
void CustomExplorerRobot::left(float speed){
    _left = -speed;
    _right = speed;
}

void CustomExplorerRobot::right(float speed){
    _left = speed;
    _right = -speed;
}

void CustomExplorerRobot::stop(void){
    _left = 0.0f;
    _right = 0.0f;
}
