/*
 * This is my code. It takes 16 samples of the analog in pins and writes the values back to the serial port.
 * Nathan Lasseter 2010
 */

#include "mbed.h"
#include "TextLCD.h"

extern void fft(float inarr[16], float outarr[16]);             //look for fft at link not compile time

//Serial pc(USBTX,USBRX);                                       ///dev/ttyACM0 is locked on university pc's
Serial pc(p9,p10);                                            //So I use /dev/ttyS0 instead
BusOut bargraph(p21,p22,p23,p24,p25,p26,p27,p28,p29,p30);       //Dot matrix bargraphs horizontal bus
BusOut graphs(p11,p12,p13,p14,p15,p16,p17,p18);                 //Dot matrix bargraphs vertical bus
AnalogIn   left(p19);                                           //Left channel input
AnalogIn   right(p20);                                          //Right channel input

void outputmatrix(float avg, int which) {                       //This is the simple dot matrix driver.
        switch (which) {                                        //Select a bargraph
            case 8: graphs = 0xFF;                              //8: off
            case 0: graphs = 0xFE;                              //0-7 are right to left. They turn on a bargraph by going low.
            case 1: graphs = 0xFC;
            case 2: graphs = 0xF8;
            case 3: graphs = 0xF0;
            case 4: graphs = 0xE0;
            case 5: graphs = 0xC0;
            case 6: graphs = 0x80;
            case 7: graphs = 0x00;
        }
        if (avg > 0.9) { bargraph=0x3FF; return; }              //Same principle, but set a value on the graph.
        if (avg > 0.8) { bargraph=0x1FF; return; }
        if (avg > 0.7) { bargraph=0x0FF; return; }
        if (avg > 0.6) { bargraph=0x07F; return; }
        if (avg > 0.5) { bargraph=0x03F; return; }
        if (avg > 0.4) { bargraph=0x01F; return; }
        if (avg > 0.3) { bargraph=0x00F; return; }
        if (avg > 0.2) { bargraph=0x007; return; }
        if (avg > 0.1) { bargraph=0x003; return; }
        if (avg > 0.0) { bargraph=0x001; return; }
        bargraph=0x000;                                         //Default to all off
}

int main() {                                                    //Main code
    while(1) {
        int i;
/*        float leftin[16], leftout[16];                        //While technically it can support 16 bands over each of 2 channels...
        float rightin[16], rightout[16];
        for(i=0;i<16;i++) leftin[i] = left;
        for(i=0;i<16;i++) rightin[i] = right;
        fft(leftin, leftout);
        fft(rightin, rightout); */
        float in[16], out[16], avg[8];                          //I only use 8 on one channel
        for(i=0;i<16;i++) in[i] = (left + right) / 2;           //So I average the two
        fft(in, out);
        for(i=0;i<8;i++) avg[i] = (out[2*i] + out[(2*i)+1]) / 2;    //And then average pairs of bands
/*        pc.printf("%f %f %f %f  %f %f %f %f\t%f %f %f %f  %f %f %f %f\n",
            leftout[0], leftout[1], leftout[2], leftout[3],
            leftout[4], leftout[5], leftout[6], leftout[7],
            leftout[8], leftout[9], leftout[10], leftout[11],
            leftout[12], leftout[13], leftout[14], leftout[15]);
        pc.printf("%f %f %f %f  %f %f %f %f\t%f %f %f %f  %f %f %f %f\n\n",
            rightout[0], rightout[1], rightout[2], rightout[3],
            rightout[4], rightout[5], rightout[6], rightout[7],
            rightout[8], rightout[9], rightout[10], rightout[11],
            rightout[12], rightout[13], rightout[14], rightout[15]); */
        pc.printf("%f %f %f %f\t%f %f %f %f\r\n",             //Then print the values to the uart
            avg[0], avg[1], avg[2], avg[3],
            avg[4], avg[5], avg[6], avg[7]);
        for(i=0;i<8;i++) outputmatrix(avg[i], i);               //And display on the bargrpahs
    }
}