#include "mbed.h"

Serial pc(USBTX, USBRX);
LocalFileSystem local("local");

void get_from_pc(char* buffer) {
    char c;
    int i;
    for (i=0; i<64; i++) buffer[i] = '\0';
    i=0;
    pc.printf(": ");
    while ((i<64) && ((c = pc.getc()) != '\n')) {
        if (c == 0x7f) {
            if (i>0) {
                i--;
                buffer[i] = '\0';
                pc.putc(8);
                pc.putc(' ');
                pc.putc(8);
            }
        } else {
            pc.putc(c);
            buffer[i] = c;
            i++;
        }
    }
    pc.printf("\n\r");
}

void ls() {
    DIR* d = opendir("/local");
    struct dirent *p;
    while ((p=readdir(d)) != NULL) pc.printf("%s\n\r", p->d_name);
    closedir(d);
}

void cat(char* buffer) {
    int i;
    signed char c;
    char filepath[19] = "/local/";
    for (i=0;i<60;i++) buffer[i] = buffer[i+4];
    for (i=7;i<19;i++) filepath[i] = buffer[i-7];
    FILE* file = fopen(filepath, "r");
    while ((c=fgetc(file)) != EOF) {
        pc.putc(c);
        if (c == '\n') pc.putc('\r');
    }
    fclose(file);
    pc.printf("\r");
}

void ed(char* buffer) {
    int i;
    signed char c;
    char filepath[19] = "/local/";
    for (i=0;i<61;i++) buffer[i] = buffer[i+3];
    for (i=7;i<19;i++) filepath[i] = buffer[i-7];
    FILE* file = fopen(filepath, "w");
    c = pc.getc();
    while ((c != 4) && (c != EOF)) {
        if (c == 0x7F) {
            pc.putc(8);
            pc.putc(' ');
            pc.putc(8);
            fseek(file, -1, SEEK_CUR);
        } else {
            pc.putc(c);
            fputc(c, file);
            if (c == '\n') pc.putc('\r');
        }
        c = pc.getc();
    }
    pc.printf("\n\r");
    fputc('\n', file);
    fflush(file);
    fclose(file);
}

int main() {
    char buffer[64];
    pc.baud(115200);
    pc.printf("Local Flash Filesystem Test\n\r");
    pc.printf("Nathan Lasseter 2010\n\n\r");
    pc.printf("Up to 64 characters input is allowed,\n\r\tup to 8 character filenames (excluding extension)\n\r");
    pc.printf("Commands: ls, cat filename, ed filename\n\n\r");
    while(1) {
        get_from_pc(buffer);
        if (strncmp(buffer, "ls", 2) == 0) {
            ls();
        } else if (strncmp(buffer, "cat", 3) == 0) {
            cat(buffer);
        } else if (strncmp(buffer, "ed", 2) == 0) {
            ed(buffer);
        } else if (strcmp(buffer, "") == 0) {
            pc.printf("! No command\n\r");
        } else {
            pc.printf("! Invalid Command <%s>\n\r", buffer);
        }
    }
}