#include "mbed.h"

Timer t;
DigitalOut idle(LED1);
DigitalOut busy(LED2);
DigitalOut open(p10);
InterruptIn start(p15);
Serial pc(USBTX, USBRX);

int led=0;

void onfall() {
    pc.printf("Door Opened... ");
    t.start();
    open=1;
    idle=0;
    led=1;
}

void onrise() {
    t.stop();
    open=0;
    pc.printf("Door Closed at %f\r\n", t.read());
    t.reset();
    busy=0;
    led=0;
}

int main() {
    open=busy=idle=0;
    start.fall(&onfall);
    start.rise(&onrise);
    while(1) {
        if(led) {
            busy = !busy;
        } else {
            idle = !idle;
        }
        wait(1);
    }
}