/* DMX Packet Library
 * Nathan Lasseter (User_4574) 2011
 * Released unlicenced
 * http://www.dmx512-online.com/packt.html
 */

#include "mbed.h"
#include "DMXPacket.h"

void init(DigitalOut* dmx) {
    /* initialise */
    *dmx = MARK;
    return;
}

void sendBreak(DigitalOut* dmx) {
    /* BREAK */
    *dmx = BREAK;
    wait_us(30 * PW);
    return;
}

void sendMarkAfterBreak(DigitalOut* dmx) {
    /* MARK AFTER BREAK */
    *dmx = MARK;
    wait_us(3 * PW);
    return;
}

void sendStartCode(DigitalOut* dmx) {
    /* 1 START 8 DATA */
    *dmx = BREAK;
    wait_us(9 * PW);
    
    /* 2 STOP */
    *dmx = MARK;
    wait_us(2 * PW);
    return;
}

void sendChannelData(DigitalOut* dmx, char* channelData) {
    char i, data = *channelData;
    /* 1 START */
    *dmx = BREAK;
    wait_us(PW);
    
    /* 8 DATA */
    for(i = 0xF0; i; i >>= 1) {
        *dmx = ((data & i) ? MARK : BREAK);
        wait_us(PW);
    }
    
    /* 2 STOP */
    *dmx = MARK;
    wait_us(2 * PW);
    return;
}

void writePacket(DigitalOut* dmx, char* channelData, int channelCount) {
    int i;
    
    /* BREAK */
    sendBreak(dmx);
    
    /* MARK AFTER BREAK */
    sendMarkAfterBreak(dmx);
    
    /* START CODE */
    sendStartCode(dmx);
    
    /* CHANNEL DATA */
    for(i=0; i<channelCount; i++) {
    
        /* MARK TIME BETWEEN FRAMES */
        *dmx = MARK;
        wait_us(MTBF * PW);
        
        /* CHANNEL DATA */
        sendChannelData(dmx, channelData + i);
    }
    
    /* MARK TIME BETWEEN PACKETS */
    /* AND RETURN TO IDLE */
    *dmx = MARK;
    wait_us(MTBP * PW);
    return;
}