#include "mbed.h"
#include "iface.h"
#include "memory.h"

LocalFileSystem local("local");

extern int channelPointer;
extern char* channelData;

void saveMemory() {
    int chan;
    FILE* mem = fopen("/local/memory.txt", "w");
    for(chan = 0; chan < CHANNELCOUNT; chan++)
        if(channelData[chan])
            fprintf(mem, "%03d %03hhd\r\n", chan, channelData[chan]);
    fclose(mem);
}

void loadMemory() {
    int chan;
    char val;
    for(chan = 0; chan < CHANNELCOUNT; chan++) channelData[channelPointer] = 0;
    FILE* mem = fopen("/local/memory.txt", "r");
    while(fscanf(mem, "%d %hhd ", &chan, &val) != EOF) channelData[chan] = val;
    fclose(mem);
    channelPointer = 0;
}