#include "mbed.h"
#include "DMXPacket.h"
#include "iface.h"
#include "TextLCD.h"

DigitalOut dmx(p20);
InterruptIn intr(p29);
I2C io(p28, p27);

TextLCD lcd(p16, p15, p13, p12, p11, p10); // rs, e, d4-d7

int channelPointer = 0;
char* channelData = (char*) calloc(CHANNELCOUNT, sizeof(char));
int waddr = 0x40;
int raddr = waddr+1;

int main() {
    char byte[1];
    io.frequency(100000);
    byte[0]=0x0F;
    io.write(waddr, byte, 1);
    
    intr.fall(&keypress);
    
    init(&dmx);
    
    lcd.cls();
    lcd.printf("   Welcome to\n ** DMXDebug! **");
    wait(2);
    lcd.cls();
    
    //printf("\r\nWelcome to DMXDebug!\r\n");
    while (1) {
        //printf("\rChannel: %03d\t\tData: %03d", channelPointer, channelData[channelPointer]);
        lcd.locate(0, 0);
        lcd.printf("Channel : %03d\n   Data : %03d", channelPointer, channelData[channelPointer]);
        writePacket(&dmx, channelData, CHANNELCOUNT);
    }
}