#include "mbed.h"
#include "iface.h"
#include "memory.h"

Timeout timer;
char keydown = 0;

extern I2C io;
extern int channelPointer;
extern char* channelData;
extern int waddr;
extern int raddr;

void nextChannel() {
    if (channelPointer < (CHANNELCOUNT - 1)) channelPointer++;
}
void previousChannel() {
    if (channelPointer > 0) channelPointer--;
}
void incrementValue() {
    if (channelData[channelPointer] < 255) channelData[channelPointer]++;
}
void decrementValue() {
    if (channelData[channelPointer] > 0) channelData[channelPointer]--;
}
void homeChannel() {
    channelPointer = 0;
}
void zeroValue() {
    channelData[channelPointer] = 0;
}
void maxValue() {
    channelData[channelPointer] = 255;
}

void handle(char key) {
    switch(key) {
        case 0x11:
            homeChannel();
            break;
        case 0x42:
            nextChannel();
            break;
        case 0x12:
            previousChannel();
            break;
        case 0x21:
            incrementValue();
            break;
        case 0x24:
            decrementValue();
            break;
        case 0x48:
            maxValue();
            break;
        case 0x18:
            zeroValue();
            break;
        case 0x14:
            saveMemory();
            break;
        case 0x44:
            loadMemory();
            break;
    }
}

void keyhandle() {
    if(keydown) {
        handle(keydown);
        timer.attach_us(&keyhandle, 20000);
    }
}

void keypress() {
    char byte0f, bytef0;
    io.read(raddr, &byte0f, 1);
    bytef0 = 0xF0;
    io.write(waddr, &bytef0, 1);
    io.read(raddr, &bytef0, 1);
    keydown = ~(byte0f | bytef0);
    if(keydown) {
        handle(keydown);
        if((keydown != 0x14) && (keydown != 0x44)) timer.attach_us(&keyhandle, 500000);
    }
    byte0f = 0x0F;
    io.write(waddr, &byte0f, 1);
}