#include "mbed.h"
//#define Button1 p14

void nibbleLeds(int value);
int lauflicht(bool richtung, int time, int&anz);
void printb(uint8_t);
int modifyBit(int x, unsigned char position, bool State);
BusOut myleds(LED1, LED2, LED3, LED4);
DigitalIn button(BUTTON1);

const int INIT = 0x03;

int main() {
    int anzahl, anz;
    uint8_t value = INIT;
    
    anzahl = lauflicht(true, 400, anz=0);
    printf("anzahl= %d\n", anzahl);
    nibbleLeds(value);
    printb(value);
    printb(myleds);
    printb(modifyBit(INIT, 3, 1));
    wait(0.1);
}

void nibbleLeds(int value)
{
    myleds = value%16;
}

int lauflicht(bool richtung, int time, int&anz)
{
    uint8_t lauf = 0x01;
    
    if(!richtung)
        lauf = 0x08;
    
    while(1){
        nibbleLeds(lauf&0x0F);
        if(richtung){
            lauf = lauf << 1;
            
            if(lauf > 8)
                lauf = 0x01;
        }
        else{
            lauf = lauf >> 1;
            if(lauf == 0)
                lauf = 0x08;
        }
        if(button)
            break;
        wait_ms(time);
        anz++;
    }
    return anz;
}

void printb(uint8_t x)
{
    for(int i=8; i; i--)
        printf("%d", (x>>(i-1)) &1);
    printf("\n");
}

int modifyBit(int x, uint8_t position, bool State)
{
    int mask = 1 << position;
    return x | mask;
}    