//////////////////////////////////////////////
//  Setzen/Löschen/Togglen                  //
//  NUCLEO-L432KC                           //
//  Stefan Simbürger                        //
//  10.01.2020                              //
//  Der einfachkeitshalber wurde die        //
//  Aufgabe mit 8 Leds und 5 Buttons        //
//  bei einem bestehenden Aufbau            //
//  durchgeführt                            //
//////////////////////////////////////////////

#include "mbed.h"


BusOut Leds(D12, D11, D10, D6, D5, D4, D3, D2);
BusIn Btn(A0, A1, A2, A6, A7);
Timer T1;

int main() {
    uint8_t maskLsbMsb = 0x81;
    T1.start();
    unsigned long actualTime;
    unsigned long lastTrigger;
    uint8_t ButtonState;
    uint8_t LastButtonState;
    
    while(1) {
        ButtonState = Btn.read();
        actualTime = T1.read_ms();
        // Sets LSB and MSB
        if(Btn == 0x01) // Button A0
        {
            Leds = Leds | maskLsbMsb;
        }
        // Deletes LSB and MSB
        if(Btn == 0x02) // Button A1
        {
            Leds = Leds & !maskLsbMsb;
        }
        // Toggles LSB and MSB
        // Debouncing the button
        if(Btn == 0x04 && ButtonState ^ LastButtonState && (actualTime - lastTrigger) > 500 ) // Button A2
        {
            Leds = Leds ^ maskLsbMsb;
            lastTrigger = T1.read_ms();
        }
        LastButtonState = ButtonState;
        // Sets all LEDs
        if(Btn == 0x03) // Button A0 & A1
        {
            Leds = Leds | 0xFF;
        }
        // Deletes all seted LEDs
        if(Btn == 0x08) // Button A6
        {
            Leds = Leds & ~Leds.read();
        }
        // Sets 3rd and 5th LED
        if(Btn == 0x10) // Button A7
        {
            Leds = Leds | 0x14;
        }
    }
}
