//////////////////////////////////////////////
//  Übungen zur PWM                         //
//  NUCLEO-L432KC                           //
//  Stefan Simbürger                        //
//  10.01.2020                              //
//  Übungen zu PWM an einer RGB-LED         //
//////////////////////////////////////////////

#include "mbed.h"

PwmOut ledR(D1);
BusOut ledStrip(D12, D11, D10, D6, D5, D4, D3, D2);
Ticker t1;
Ticker t_ledStrip;

void LedR();        // Makes the red part of the RGB_LED up to 30% bright
void timeCounter(); // Counts PWM steps in binary

int main() {
    ledR.period(0.0001f);
    // Ticker t1 gets called after 10000 cycles
    t1.attach(callback(&LedR), 0.0001f * 10000);
    t_ledStrip.attach(callback(&timeCounter), 0.0001f* 10000);
    
}

// Increases the LED brightness by 1% each step
// up to 30%
 void LedR()
{
     ledR.write(ledR.read() + 0.01f);
     if(ledR.read() >= 0.3f)
     {
         ledR.write(0.0f);
     }
}
// Because of the same timelapse this function
// counts every step of the PWM in a binary system
 void timeCounter()
{
     if(ledStrip == 0x00 || ledR.read() == 0.0f)
     {
        ledStrip = 0x01;
     }
     else
     {
         ledStrip = ledStrip + 1;
     }
     
}