//////////////////////////////////////////////
//  Übungen zum AnalogIn                    //
//  NUCLEO-L432KC                           //
//  Stefan Simbürger                        //
//  11.01.2020                              //
//  Übungen zum AnalogIn und                //
//  einem Poti. Das Programm wurde          //
//  von Visual Code hierher übertragen.     //
//////////////////////////////////////////////

#include <mbed.h>
#define BtnRead A0
#define BtnPlus7 A1
#define BtnMinus11 A2
#define BtnSave A5
#define BtnAv A6

AnalogIn Poti1(A3);

// Prototyping
float PotiRead();
float PotiPlus7(float Potivalue);
float PotiMinus11(float Potivalue);
void Average(float Data);

// All InterruptIns
InterruptIn actualRead(BtnRead);
InterruptIn add7(BtnPlus7);
InterruptIn sub11(BtnMinus11);
InterruptIn save(BtnSave);
InterruptIn average(BtnAv);

// Default setting of the flagstates
bool _BtnReadPressed = false;
bool _BtnPlus7Pressed = false;
bool _BtnMinus11Pressed = false;
bool _BtnSavePressed = false;
bool _BtnAvPressed = false;
bool dataEnabled = false;

// enables interruptflags
void FlagBtnRead()
{
  _BtnReadPressed = true;
}
void FlagBtnPlus7()
{
  _BtnPlus7Pressed = true;
}
void FlagBtnMinus11()
{
  _BtnMinus11Pressed = true;
}
void FlagBtnSave()
{
  _BtnSavePressed = true;
}
void FlagBtnAv()
{
  _BtnAvPressed = true;
}

// If the interrupt flag got triggered those methods
// return true and delete the flag. 
int checkBtnRead() {
    if( _BtnReadPressed ) {
        _BtnReadPressed = false;
        return 1;
    }
    return 0;
}

int checkBtnPlus7() {
    if( _BtnPlus7Pressed ) {
        _BtnPlus7Pressed = false;
        return 1;
    }
    return 0;
}

int checkBtnMinus11() {
    if( _BtnMinus11Pressed ) {
        _BtnMinus11Pressed = false;
        return 1;
    }
    return 0;
}

int checkBtnSave() {
    if( _BtnSavePressed ) {
        _BtnSavePressed = false;
        return 1;
    }
    return 0;
}

int checkBtnAv() {
    if( _BtnAvPressed ) {
        _BtnAvPressed = false;
        return 1;
    }
    return 0;
}

int main() {
  printf("Poti-Testprogramm copyright Stefan Simbürger \n");
  uint8_t n = 0;
  float ADCarray[20], ADCData = 0; 
  actualRead.fall(&FlagBtnRead);
  add7.fall(&FlagBtnPlus7);
  sub11.fall(&FlagBtnMinus11);
  save.fall(&FlagBtnSave);
  average.fall(&FlagBtnAv);

  while(1) {
    if(checkBtnRead())
      {
        ADCData = PotiRead();
        dataEnabled = true;
      }
    if(checkBtnPlus7())
      {
        if(dataEnabled == false)
        {
          printf("Bitte Poti auslesen!\n");
        }
        else
        {
          ADCData = PotiPlus7(ADCData);
        }
      }
    if(checkBtnMinus11())
      {
        if(dataEnabled == false)
        {
          printf("Bitte Poti auslesen!\n");
        }
        else
        {
          ADCData = PotiMinus11(ADCData);
        }
      }
      
      // This function saves the value of
      // ADCData into an array
    if(checkBtnSave())
      {
        if(dataEnabled == false)
        {
          printf("Bitte Poti auslesen!\n");
        }
        else 
        {
          ADCarray[n] = ADCData;
          n++;
          printf("Gespeicherter Wert = %f\n", ADCData);
        }
      }
    if(checkBtnAv())
      {
        float sum = 0;

        if(n==0)
        {
          printf("Keine gespeicherten Werte!\n");
        }
        else
        {
          for(int i = 0; i < 10; i++)
          {
            // calculates a summary of the last 10 positions
            sum = sum + ADCarray[n-i-1];
          }
          Average(sum);
        }
      }
  }
}

// reads the actual value of the resistor.
// This function turns the float value
// of 0 to 1 into -50 to 50
float PotiRead()
{
    float ADCvalue;
    ADCvalue = Poti1.read() * 100 - 50;
    printf("Wert des Potis: %f\n", ADCvalue);
    return ADCvalue;
}

// adds 7 to the value of ADCData
float PotiPlus7(float Potivalue)
{
    Potivalue = Potivalue + 7;
    printf("Wert des Poti plus 7: %f\n", Potivalue);
    return Potivalue;
}

// reduces the value of ADCData by 11
float PotiMinus11(float Potivalue)
{
    Potivalue = Potivalue - 11;
    printf("Wert des Poti minus 11: %f\n", Potivalue);
    return Potivalue;
}

// Calcultes the average of the last 10
// positions of ADCarray[]
void Average(float Data)
{
  Data = Data / 10;
  printf("Der durchschnittliche Wert beträgt: %f\n", Data);
}