#include "mbed.h"

/************************************************
*               PPM-Decoder                     *
*       Gets the signal of a Turnigy iA8        *
*       2.4GHz PPM-Receiver and saves           *
*       every channel into an Array. The        *
*       pauses get subtractet, because          *
*       the Encoder is generating new ones.     *
************************************************/

InterruptIn signal(A0);
Timer t_Receiver_Ch_Signal;
unsigned short all_Ch[8];
unsigned short current_Ch;
unsigned char state_Of_Signal;



void isrFall()
{
    current_Ch = t_Receiver_Ch_Signal.read_us();
    t_Receiver_Ch_Signal.reset();
    
    if(current_Ch >= 6000) {
        state_Of_Signal = 0;
    }
    else if(current_Ch <= 1000)
    {
        return;
    }
    else{
        all_Ch[state_Of_Signal] = current_Ch - 400;
        state_Of_Signal++;
    }
    
}

int main()
{
    t_Receiver_Ch_Signal.reset();
    t_Receiver_Ch_Signal.start();
    signal.fall(&isrFall);
    state_Of_Signal = 0;
    while (1) {
        for(int i = 0; i < 8; i++)
        {
            printf("Channel %d: %d \n", i + 1, all_Ch[i]);
        }
        printf("End of Signal\n");
        wait_ms(2000);
    }
    return 0;
}
