#include "mbed.h"
// new class to play a note on Speaker based on PwmOut class
class Speaker
{
public:
    Speaker(PinName pin) : _pin(pin) {
// _pin(pin) means pass pin to the Speaker Constructor
    }
// class method to play a note based on PwmOut class
    void PlayNote(float frequency, float frequency2, float duration, float volume) {
        if (frequency == 0) {
            _pin.period(1.0/frequency2);
            _pin = volume/2.0;
            wait(duration);
            }
        else if(frequency2 == 0) {
            _pin.period(1.0/frequency);
            _pin = volume/2.0;
            wait(duration);
            }
        else {
           _pin.period(1.0/frequency);
            _pin = volume/2.0;
        wait(.008);
        _pin = 0.0;
        _pin.period(1.0/frequency2);
        _pin = volume/2.0;
        wait(.008);
        }
    }
    
    void StopPlaying() {
        _pin = 0;
        wait(0.001);
    }
 
private:
    PwmOut _pin;
};