#include <mbed.h>
#include <mpr121.h>
#include "uLCD_4DGL.h"
#include "Speaker.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "wavfile.c"
#include "wavfile.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "wave_player.h"

SDFileSystem sd(p5, p6, p7, p8,"sd"); //SD card

uLCD_4DGL uLCD(p13,p14,p11);

// Create the interrupt receiver object on pin 26
InterruptIn interrupt1(p26);
InterruptIn interrupt2(p25);
// Setup the i2c bus on pins 9 and 10
I2C i2c1(p9, p10);
I2C i2c2(p28, p27);
// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 tones1pad(&i2c1, Mpr121::ADD_VSS);
Mpr121 tones2pad(&i2c2, Mpr121::ADD_VSS);

Speaker mySpeaker(p21);
InterruptIn pb1(p12);
InterruptIn pb2(p29);

AnalogOut DACout(p18);
wave_player waver(&DACout);

int key_code [2] = {88,88};
int touches;
int music [1000] = { };
int music2 [1000] = { };

const int NUM_SAMPLES = (WAVFILE_SAMPLES_PER_SECOND*0.2);
int flagPb;
bool flagPb2;
bool flagInterrupt;
 
// Key hit/release interrupt routine for 1st touchpad
void fallInterrupt1()
{
  key_code[0]=88;
  key_code[1]=88;
  flagInterrupt = true;
  
  int value=tones1pad.read(0x00);
  value +=tones1pad.read(0x01)<<8;  
  
  int k = 0;  
  for(int i=0; i<12; i++) 
  {    
    if(((value>>i)&0x01) == 1)
    {
        key_code[k] = i;
        if (k < 1){
            k=k+1;
        }
    }    
  }
  uLCD.locate(1,2);
  //uLCD.printf("%2D%2D",key_code[0],key_code[1]);
  touches = touches + 1;
}

//sets up interrupts for 2nd toucpad
void fallInterrupt2() {
  key_code[0]=88;
  key_code[1]=88;
  flagInterrupt = true;
  
  int value2=tones2pad.read(0x00);
  value2 +=tones2pad.read(0x01)<<8;
  
  // puts key number out to LEDs for demo
  int k = 0;
  for(int j=0; j<12; j++) 
  {        
    if(((value2>>j)&0x01) == 1)
    {
        key_code [k] = j +12;        
        if (k < 1){
            k=k+1;
        }
    }
  }
  
  uLCD.locate(1,3);
  //uLCD.printf("%2D%2D",key_code[0],key_code[1]);
  touches = touches + 1;
}

void pb1_hit_interrupt (void)
{      
    if (flagPb == 0)
    {
        touches = 0;
        
        uLCD.locate(1,1);
        uLCD.printf("Start Recording");
        uLCD.locate(1,5);
        uLCD.printf("Waiting");
        flagPb = 1;

    }
    else if (flagPb == 1)
    {
        FILE * f = wavfile_open("/sd/Example14.wav");
        uLCD.locate(1,1);
        uLCD.printf("Recording ended");
        uLCD.locate(1,4);
        uLCD.printf("touches = %d",touches);
        uLCD.locate(1,6);
        /*
        for (int k = 0; k<=touches; k++)
        {
            uLCD.printf("%d",music[k]);
        }
        */  
        for (int k = 0; k<=touches; k++){
            short waveform[NUM_SAMPLES];
            double frequency = music[k]; //880.0;
            double frequency2 = music2[k];            
            int volume = 32000;            
            int length = NUM_SAMPLES;   
            int i;
            for(i=0;i<length;i++) {
                double t = (double) i / WAVFILE_SAMPLES_PER_SECOND;
                if (frequency2 == 0)
                {
                    waveform[i] = volume*sin(frequency*t*2*3.1415926);
                }
                else if (frequency2 != 0)
                {
                    waveform[i] = volume*(sin(frequency*t*2*3.1415926)+sin(frequency2*t*2*3.1415926))/2;
                }
            }
            if (music[k] == 0)
            {
                int length_short = length*2/9;
                fwrite(waveform,sizeof(short),length_short,f);
            }
            else if (music[k] != 0)
            {
                fwrite(waveform,sizeof(short),length,f);
            }
        }
        wavfile_close(f);        
               
        uLCD.locate(1,5);
        uLCD.printf("Done   ");
        flagPb = 0;
    }    
}

void pb2_hit_interrupt (void)
{
    flagPb2 = true;
    uLCD.cls();
    uLCD.locate(1,1);
    uLCD.printf("Let the fun begin\n");
}

int main()
{    
    touches = -1;
    flagPb = 0;
    flagInterrupt = false;
    
    key_code[0] = 88;
    key_code[1] = 88;
    
    pb1.fall(&pb1_hit_interrupt);
    wait(.2);
    pb1.mode(PullUp);
    wait(.2);
    
    pb2.mode(PullUp);
    wait(.2);
    pb2.fall(&pb2_hit_interrupt);
    wait(.2);
     
    interrupt2.fall(&fallInterrupt2);
    interrupt2.mode(PullUp);
    interrupt1.fall(&fallInterrupt1);
    interrupt1.mode(PullUp);
        
    while(1)
    {
            
      if ( (flagPb == 1) && (flagInterrupt == false ))
      {
          
          touches = touches + 1;
          music[touches] = 0;
          music2[touches] = 0;
          wait(0.05);
          //flagInterrupt = false;
      }
      
      if (flagPb2 == true)
      { 
        FILE *wave_file;
        uLCD.locate(1,6);
        uLCD.printf("Playing");    
        wave_file=fopen("/sd/Example14.wav","r");
        waver.play(wave_file);        
        fclose(wave_file);
        flagPb2 = false;
        uLCD.locate(1,7);
        uLCD.printf("Playing Ended");
      }
      
      if (key_code[1] == 88)
      {
        music2[touches] = 0;
        switch(key_code[0]) //uses a case for each individual touch sensor
        {            
            case 0:
                mySpeaker.PlayNote(262,0,0.2,1);
                music[touches] = 262;
                flagInterrupt = false;
                mySpeaker.StopPlaying();         
                break;
            case 1:
                mySpeaker.PlayNote(277,0,0.2,1);
                music[touches] = 277;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 2:
                mySpeaker.PlayNote(294,0,0.2,1);
                music[touches] = 294;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 3:
                mySpeaker.PlayNote(311,0,0.2,1);
                music[touches] = 311;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 4:
                mySpeaker.PlayNote(330,0,0.2,1);
                music[touches] = 330;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 5:
                mySpeaker.PlayNote(349,0,0.2,1);
                music[touches] = 349;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 6:
                mySpeaker.PlayNote(370,0,0.2,1);
                music[touches] = 370;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 7:
                mySpeaker.PlayNote(392,0,0.2,1);
                music[touches] = 392;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 8:
                mySpeaker.PlayNote(415,0,0.2,1);
                music[touches] = 415;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 9:
                mySpeaker.PlayNote(440,0,0.2,1);
                music[touches] = 440;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 10:
                mySpeaker.PlayNote(466,0,0.2,1);
                music[touches] = 466;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 11:
                mySpeaker.PlayNote(494,0,0.2,1);
                music[touches] = 494;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 12:
                mySpeaker.PlayNote(523,0,0.2,1);
                music[touches] = 523;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 13:
                mySpeaker.PlayNote(554,0,0.2,1);
                music[touches] = 554;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 14:
                mySpeaker.PlayNote(587,0,0.2,1);
                music[touches] = 587;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 15:
                mySpeaker.PlayNote(622,0,0.2,1);
                music[touches] = 622;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 16:
                mySpeaker.PlayNote(659,0,0.2,1);
                music[touches] = 659;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 17:
                mySpeaker.PlayNote(698,0,0.2,1);
                music[touches] = 698;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 18:
                mySpeaker.PlayNote(740,0,0.2,1);
                music[touches] = 740;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 19:
                mySpeaker.PlayNote(784,0,0.2,1);
                music[touches] = 784;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 20:
                mySpeaker.PlayNote(830,0,0.2,1);
                music[touches] = 830;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 21:
                mySpeaker.PlayNote(880,0,0.2,1);
                music[touches] = 830;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 22:
                mySpeaker.PlayNote(932,0,0.2,1);
                music[touches] = 932;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 23:
                mySpeaker.PlayNote(988,0,0.2,1);
                music[touches] = 988;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            
            default:
                music[touches] = 0;
                flagInterrupt = false;
            
        }
      }
      
      if (key_code[1] != 88) //Overtunes
      {
        switch(key_code[0]) //uses a case for each individual touch sensor
        {            
            case 0:
                music[touches] = 262;                         
                break;
            case 1:
                music[touches] = 277;
                break;
            case 2:
                music[touches] = 294;
                break;
            case 3:
                music[touches] = 311;
                break;
            case 4:
                music[touches] = 330;
                break;
            case 5:
                music[touches] = 349;
                break;
            case 6:
                music[touches] = 370;
                break;
            case 7:
                music[touches] = 392;
                break;
            case 8:
                music[touches] = 415;
                break;
            case 9:
                music[touches] = 440;
                break;
            case 10:
                music[touches] = 466;
                break;
            case 11:
                music[touches] = 494;
                break;
            case 12:
                music[touches] = 523;
                break;
            case 13:
                music[touches] = 554;
                break;
            case 14:
                music[touches] = 587;
                break;
            case 15:
                music[touches] = 622;
                break;
            case 16:
                music[touches] = 659;
                break;
            case 17:
                music[touches] = 698;
                break;
            case 18:
                music[touches] = 740;
                break;
            case 19:
                music[touches] = 784;
                break;
            case 20:
                music[touches] = 830;
                break;
            case 21:
                music[touches] = 830;
                break;
            case 22:
                music[touches] = 932;
                break;
            case 23:
                music[touches] = 988;
                break;
            
            default:
                music[touches] = 0;
            
        }
        
        switch(key_code[1]) //uses a case for each individual touch sensor
        {            
            case 0:
                mySpeaker.PlayNote(music[touches],262,0.2,1);
                music2[touches] = 262;
                flagInterrupt = false;
                mySpeaker.StopPlaying();         
                break;
            case 1:
                mySpeaker.PlayNote(music[touches],277,0.2,1);
                music2[touches] = 277;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 2:
                mySpeaker.PlayNote(music[touches],294,0.2,1);
                music2[touches] = 294;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 3:
                mySpeaker.PlayNote(music[touches],311,0.2,1);
                music2[touches] = 311;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 4:
                mySpeaker.PlayNote(music[touches],330,0.2,1);
                music2[touches] = 330;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 5:
                mySpeaker.PlayNote(music[touches],349,0.2,1);
                music2[touches] = 349;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 6:
                mySpeaker.PlayNote(music[touches],370,0.2,1);
                music2[touches] = 370;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 7:
                mySpeaker.PlayNote(music[touches],392,0.2,1);
                music2[touches] = 392;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 8:
                mySpeaker.PlayNote(music[touches],415,0.2,1);
                music2[touches] = 415;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 9:
                mySpeaker.PlayNote(music[touches],440,0.2,1);
                music2[touches] = 440;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 10:
                mySpeaker.PlayNote(music[touches],466,0.2,1);
                music2[touches] = 466;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 11:
                mySpeaker.PlayNote(music[touches],494,0.2,1);
                music2[touches] = 494;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 12:
                mySpeaker.PlayNote(music[touches],523,0.2,1);
                music2[touches] = 523;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 13:
                mySpeaker.PlayNote(music[touches],554,0.2,1);
                music2[touches] = 554;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 14:
                mySpeaker.PlayNote(music[touches],587,0.2,1);
                music2[touches] = 587;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 15:
                mySpeaker.PlayNote(music[touches],622,0.2,1);
                music2[touches] = 622;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 16:
                mySpeaker.PlayNote(music[touches],659,0.2,1);
                music2[touches] = 659;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 17:
                mySpeaker.PlayNote(music[touches],698,0.2,1);
                music2[touches] = 698;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 18:
                mySpeaker.PlayNote(music[touches],740,0.2,1);
                music2[touches] = 740;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 19:
                mySpeaker.PlayNote(music[touches],784,0.2,1);
                music2[touches] = 784;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 20:
                mySpeaker.PlayNote(music[touches],830,0.2,1);
                music2[touches] = 830;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 21:
                mySpeaker.PlayNote(music[touches],880,0.2,1);
                music2[touches] = 830;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 22:
                mySpeaker.PlayNote(music[touches],932,0.2,1);
                music2[touches] = 932;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            case 23:
                mySpeaker.PlayNote(music[touches],988,0.2,1);
                music2[touches] = 988;
                flagInterrupt = false;
                mySpeaker.StopPlaying();
                break;
            
            default:
                music2[touches] = 0;
                flagInterrupt = false;
            
        }        
      }
    }
}

