#include "mbed.h"
#include "HTTPServer.h"
#include "FsHandler.h"
//#include "LocalFileSystem.h"
#include "RpcHandler.h"
#include "mbed_rpc.h"

#define ALTERNATIVE
//#undef ALTERNATIVE

//  Use LED1 to indicate that the main loop is still executing
DigitalOut myled(LED1);
//  Use the serial connection 'pc' to dump debug information
Serial pc(USBTX, USBRX, "pc");
//  Instantiate a HTTPServer to handle incoming requests
HTTPServer  svr;
//  Instantiate a local file system handler named 'local' which will be used later to access files on the mbed.
//LocalFileSystem local("local");


#ifdef ALTERNATIVE
//  Create the EthernetInterface. This is optional, please see the documentation of HTTP Server's start method.
EthernetInterface eth;
#endif


int main() {

    pc.baud(9600);
    RPC::add_rpc_class<RpcDigitalOut>();
    HTTPFsRequestHandler::mount("/local/", "/");
    svr.addHandler<HTTPFsRequestHandler>("/");
    svr.addHandler<HTTPRpcRequestHandler>("/RPC");
    
#ifdef ALTERNATIVE
    //  Initialize the EthernetInterface and initiate a connection using DHCP.
    eth.init();
    eth.connect();
    
    if (!svr.start(80, &eth)) {
#else
    if (!svr.start()) {
#endif
        error("Server not starting !");
        exit(0);
    }
    
    while(1) {
        svr.poll();
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
