#include "mbed.h"
#ifdef TARGET_UBLOX_C027
 #include "C027_api.h"
#else
 #error "This example is targeted for the C027 platform"
#endif

#include "main.h"

/* This example is establishing a transparent link between 
   the mbed serial port and the serial communication interface 
   of the GPS. 
   
   For a more advanced driver for the GPS or Modem(MDM) please 
   look at the follwing library and example:
   C027_Support Library 
     http://mbed.org/teams/ublox/code/C027_Support/
   C027_Support Example
     http://mbed.org/teams/ublox/code/C027_SupportTest/
*/


int main() 
{
    c027_gps_powerOn();
    gps.baud(baud);
    pc.baud(baud);
        
    char c;
    int n = 1500;
    char cDataBuffer[n];
    int i = 0;
    char s[4] = "\n\r";
    
    while (1)
    {
        
        if (gps.readable())
        {
            c = gps.getc();
            if (c == '$')
            {
                while (i < n)
                {
                    cDataBuffer[i] = c;
                    c = gps.getc();
                    i = i + 1;
                }
                i = 0;
                char * output = strtok(cDataBuffer, s);
//                printf( "%s ", output );
                parse(output, sizeof(output));
//                pc.printf("%d\n\r", strncmp(output,"$GNGLL",6));
                while( output != NULL ) 
                {
                    output = strtok(NULL, s);
//                    printf( "%s ", output);
                    parse(output, sizeof(output));
//                    pc.printf("%d\n\r", strncmp(output,"$GNGLL",6));
                    
                }
            }
        }
    }
}

void parse(char *cmd, int n)
{
    
    char ns, ew, tf, status;
    int fq, nst, fix, date;                                     // fix quality, Number of satellites being tracked, 3D fix
    float latitude, longitude, timefix, speed, altitude;
    
    
    // Global Positioning System Fix Data
    if(strncmp(cmd,"$GNGGA", 6) == 0) 
    {
        sscanf(cmd, "$GNGGA,%f,%f,%c,%f,%c,%d,%d,%*f,%f", &timefix, &latitude, &ns, &longitude, &ew, &fq, &nst, &altitude);
        pc.printf("GNGGA Fix taken at: %f, Latitude: %f %c, Longitude: %f %c, Fix quality: %d, Number of sat: %d, Altitude: %f M\n\r", timefix, latitude, ns, longitude, ew, fq, nst, altitude);
    }
    
    // Satellite status
    if(strncmp(cmd,"$GNGSA", 6) == 0) 
    {
        sscanf(cmd, "$GNGSA,%c,%d,%d", &tf, &fix, &nst);
        pc.printf("GNGSA Type fix: %c, 3D fix: %d, number of sat: %d\r\n\r", tf, fix, nst);
    }
    
    // Geographic position, Latitude and Longitude
    if(strncmp(cmd,"$GNGLL", 6) == 0) 
    {
        sscanf(cmd, "$GNGLL,%f,%c,%f,%c,%f", &latitude, &ns, &longitude, &ew, &timefix);
        pc.printf("GNGLL Latitude: %f %c, Longitude: %f %c, Fix taken at: %f\n\r", latitude, ns, longitude, ew, timefix);
    }
    
    // Geographic position, Latitude and Longitude
    if(strncmp(cmd,"$GNRMC", 6) == 0) 
    {
        sscanf(cmd, "$GNRMC,%f,%c,%f,%c,%f,%c,%f,,%d", &timefix, &status, &latitude, &ns, &longitude, &ew, &speed, &date);
        pc.printf("GNRMC Fix taken at: %f, Status: %c, Latitude: %f %c, Longitude: %f %c, Speed: %f, Date: %d\n\r", timefix, status, latitude, ns, longitude, ew, speed, date);
    }
}
