#include "mbed.h"

//------------------------------------------------------------------------------------
/* This example was tested on C027-U20 and C027-G35 with the on board modem. 
   
   Additionally it was tested with a shield where the SARA-G350/U260/U270 RX/TX/PWRON 
   is connected to D0/D1/D4 and the GPS SCL/SDA is connected D15/D15. In this 
   configuration the following platforms were tested (it is likely that others 
   will work as well)
   - U-BLOX:    C027-G35, C027-U20, C027-C20 (for shield set define C027_FORCE_SHIELD)
   - NXP:       LPC1549v2, LPC4088qsb
   - Freescale: FRDM-KL05Z, FRDM-KL25Z, FRDM-KL46Z, FRDM-K64F
   - STM:       NUCLEO-F401RE, NUCLEO-F030R8
                mount resistors SB13/14 1k, SB62/63 0R
*/
#include "MDM.h"
//------------------------------------------------------------------------------------
// You need to configure these cellular modem / SIM parameters.
// These parameters are ignored for LISA-C200 variants and can be left NULL.
//------------------------------------------------------------------------------------
//! Set your secret SIM pin here (e.g. "1234"). Check your SIM manual.
#define SIMPIN      NULL
/*! The APN of your network operator SIM, sometimes it is "internet" check your 
    contract with the network operator. You can also try to look-up your settings in 
    google: https://www.google.de/search?q=APN+list */
#define APN         NULL
//! Set the user name for your APN, or NULL if not needed
#define USERNAME    NULL
//! Set the password for your APN, or NULL if not needed
#define PASSWORD    NULL 
//------------------------------------------------------------------------------------

int main(void)
{

    // Create the modem object
    MDMSerial mdm(MDMTXD, MDMRXD);
//    mdm.setDebug(4); // enable this for debugging issues 
    
    mdm.init();
    wait(1);
    
    mdm.connect();
    // initialize the modem //
//    MDMParser::DevStatus devStatus = {};
//    MDMParser::NetStatus netStatus = {};
//    bool mdmOk = mdm.init(SIMPIN, &devStatus);
//    mdm.dumpDevStatus(&devStatus);
    //if (mdmOk) {
//        // wait until we are connected
//        mdmOk = mdm.registerNet(&netStatus);
//        mdm.dumpNetStatus(&netStatus);
//    }
//    if (mdmOk)
//    {
//        // http://www.geckobeach.com/cellular/secrets/gsmcodes.php
//        // http://de.wikipedia.org/wiki/USSD-Codes
//        
//        // join the internet connection 
//        MDMParser::IP ip = mdm.join(APN,USERNAME,PASSWORD);
//       
//    }
            
    mdm.disconnect();
    //DigitalOut led(LED1);
    mdm.powerOff();
    return 0;
}
