#include "mbed.h"
//#include "USBMouse.h"
#include "USBJoystick.h"

//USBMouse mouse;
USBJoystick joystick;

// Variables for Heartbeat and Status monitoring
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut heartbeatLED(LED4);
DigitalIn B1(p5);
DigitalIn B2(p6);
DigitalIn B3(p7);
DigitalIn B4(p8);
DigitalIn B5(p9);
AnalogIn IN(p20);
Ticker heartbeat;
//Serial pc(USBTX, USBRX); // tx, rx

// Heartbeat monitor
void pulse() {
  heartbeatLED = !heartbeatLED;
}

void heartbeat_start() {
  heartbeat.attach(&pulse, 0.5);
}

void heartbeat_stop() {
  heartbeat.detach();
}


int main() {
    //int16_t i = 0;
    int8_t i = 0;
    int16_t throttle = 0;
    int16_t rudder = 0;    
    int16_t x = 0;
    int16_t y = 0;
    int32_t radius = 120;
    int32_t angle = 0;
    int8_t button = 0;    
    int8_t hat = 0;    
    int counter = 0;
        B1.mode(PullUp);
        B2.mode(PullUp);
        B3.mode(PullUp);
        B4.mode(PullUp);
        B5.mode(PullUp);
    
//    pc.printf("Hello World!\n\r");

    heartbeat_start();

    while (1) {
        // Basic Joystick
//        throttle = (i >> 8) & 0x00; // value -127 .. 128
//        rudder =   (i >> 8) & 0x00;   // value -127 .. 128        
        throttle = IN.read_u16();
       // if (throttle == 0)
       //     throttle = 127;
       // else throttle = 0;// value -127 .. 128
        //printf("%d \r\n", throttle);
        rudder =   i;   // value -127 .. 128        

        
        //button =   (i >> 8) & 0x00;   // value    0 .. 15, one bit per button     
        //button =   i;   // value    0 .. 15, one bit per button             
//      hat    =   (i >> 8) & 0x03;   // value 0, 1, 2, 3 or 4 for neutral 
        hat    =   (i >> 8) & 0x00;   // value 0..7 or 8 for neutral         
        //i++;        
        
        //throttle = cos((double)angle*3.14/180.0)*radius;  // value -127 .. 128
        //rudder = cos((double)angle*3.14/180.0)*radius;  // value -127 .. 128
        
        x = cos((double)angle*3.14/180.0)*radius;  // value -127 .. 128
        y = sin((double)angle*3.14/180.0)*radius;  // value -127 .. 128
        angle += 3;
        /*
         if (!B1){
            //i = 1;
            button = 2;
            myled3=1;
            }
        else{
            //i = 0;
            button = 0;
            myled3=0;            
            }
 */
        if (button == 0)
            {
                button = i;
                i++;
                }
      
        else button = 0;
        joystick.update(throttle, rudder, x, y, button, hat);
        if (counter == 50)
            {
                myled2 = !myled2;
                counter = 0;
                }
        counter++;
        wait(0.1);
    }
    
 //   pc.printf("Bye World!\n\r");                           
}