/* Copyright (c) 2010-2011 mbed.org, MIT License
* Modified Mouse code for Joystick - WH 2012
*
* Permission is hereby granted, free of charge, to any person obtaining a copy of this software
* and associated documentation files (the "Software"), to deal in the Software without
* restriction, including without limitation the rights to use, copy, modify, merge, publish,
* distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all copies or
* substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
* BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
* NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
* DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "stdint.h"
#include "USBJoystick.h"

bool USBJoystick::update(int16_t t, int16_t r, int16_t x, int16_t y, uint8_t button, uint8_t hat) {
   HID_REPORT report;
   _t = t;
   _r = r;   
   _x = x;
   _y = y;
   _button = button;     
   _hat = hat;
   
// Fill the report according to the Joystick Descriptor
/*
   report.data[0] = _t & 0xff;            
   report.data[1] = _r & 0xff;               
   report.data[2] = _x & 0xff;            
   report.data[3] = __x & 0xff;            
   report.data[4] = ((_button & 0x0f) << 4) | (_hat & 0x0f) ;                                      
   report.length = 5; 
*/
   // Fill the report according to the Joystick Descriptor
report.data[0] = 0x01;    // report_id
report.data[1] = 0x00;    //reserved
report.data[2] = (_button & 0x0f) << 4 | (_button & 0x0f) ;    // buttons 1 - 8  ab
//report.data[3] = ((_button & 0x0f) << 4) | (_hat & 0x0f) ;;    // buttons 17 - 19 / filling bits 1 -5  ef
report.data[3] = (_button & 0x0f) << 4 | (_button & 0x0f) ;    //buttons 9 - 16  cd   sq x 0 tr
report.data[4] = (_button & 0x0f);    // buttons 17 - 19 / filling bits 1 -5  ef
report.data[5] = 0x00;    // filling bits 6 - 13 / 32 bits total
report.data[6] = _t & 0xff;    // X
report.data[7] = _r & 0xff;    // Y
report.data[8] = _x & 0xff;    // Z
   report.data[9] = _y & 0xff; // Rz
   report.data[10] = _y & 0xff; 
   report.data[11] = _y & 0xff;
   report.data[12] = _y & 0xff;// directional analog up
   report.data[13] = _y & 0xff;// directional analog left
   report.data[14] = _y & 0xff;// directional analog down
   report.data[15] = _y & 0xff;// directional analog right
   report.data[16] = _y & 0xff;// analog left 2
   report.data[17] = _y & 0xff;// analog right 2
   report.data[18] = _y & 0xff;// analog left 1
   report.data[19] = _y & 0xff;// analog right 1
   report.data[20] = _y & 0xff;// triangle analog
   report.data[21] = _y & 0xff;// circle analog
   report.data[22] = _y & 0xff;// x analog
   report.data[23] = _y & 0xff;// square analog
   report.data[24] = _y & 0xff;
   report.data[25] = _y & 0xff;
   report.data[26] = _y & 0xff;
   report.data[27] = _y & 0xff; // 03 ?
   report.data[28] = _y & 0xff; // ef ?
   report.data[29] = _y & 0xff; // 16 ?
   report.data[30] = _y & 0xff;
   report.data[31] = _y & 0xff;
   report.data[32] = _y & 0xff;
   report.data[33] = _y & 0xff;
   report.data[34] = _y & 0xff;//Accel x 4
   report.data[35] = _y & 0xff;//Accel x 3
   report.data[36] = _y & 0xff;//Accel x 2                                                   
   report.data[37] = _y & 0xff;//Accel x 1
   report.data[38] = _y & 0xff;//Accel y 4                                       
   report.data[39] = _y & 0xff;//Accel y 3
   report.data[40] = _y & 0xff;//Accel y 2
   report.data[41] = _y & 0xff;//Accel y 1
   report.data[42] = _y & 0xff;//Accel z 4
   report.data[43] = _y & 0xff;//Accel z 3
   report.data[44] = _y & 0xff;//Accel z 2
   report.data[45] = _y & 0xff;//Accel z 1
   report.data[46] = _y & 0xff;
   report.data[47] = _y & 0xff;
   report.data[48] = _y & 0xff;

   report.length = 49; 
   
   
   return send(&report);

}
/*
bool USBJoystick::update() {
   HID_REPORT report;

   // Fill the report according to the Joystick Descriptor
   report.data[0] = _t & 0xff;            
   report.data[1] = _r & 0xff;               
   report.data[2] = _x & 0xff;            
   report.data[3] = _y & 0xff;            
   report.data[4] = ((_button & 0x0f) << 4) | (_hat & 0x0f) ;                                      
   report.length = 5; 

   return send(&report);
}
*/
bool USBJoystick::update() {
   HID_REPORT report;
   
   // Fill the report according to the Joystick Descriptor
/*   //report.data[0] = 0x01;
   report.data[0] = _t & 0xff;            
   report.data[1] = _r & 0xff;               
   report.data[2] = _x & 0xff;            
   report.data[3] = _y & 0xff;            
   report.data[4] = ((_button & 0x0f) << 4) | (_hat & 0x0f) ;  
   */                                    
// Fill the report according to the Joystick Descriptor
report.data[0] = 0x01; //reserved
report.data[1] = 0x00;;    // buttons 1 - 8
report.data[2] = 0x00;    // buttons 9 - 16
report.data[3] = 0x00;    // buttons 17 - 19 / filling bits 1 -5
report.data[4] = 0x00;    // filling bits 6 - 13 / 32 bits total
report.data[5] = 0x7d;    // X
report.data[6] = 0x7d;    // Y
report.data[7] = 0x7d;    // Z
report.data[8] = 0x80;    // Rz
   report.data[9] = 0x00; 
   report.data[10] = 0x00; 
   report.data[11] = 0x00;
   report.data[12] = 0x00;// directional analog up
   report.data[13] = 0x00;// directional analog left
   report.data[14] = 0x00;// directional analog down
   report.data[15] = 0x00;// directional analog right
   report.data[16] = 0x00;// analog left 2
   report.data[17] = 0x00;// analog right 2
   report.data[18] = 0x00;// analog left 1
   report.data[19] = 0x00;// analog right 1
   report.data[20] = 0x00;// triangle analog
   report.data[21] = 0x00;// circle analog
   report.data[22] = 0x00;// x analog
   report.data[23] = 0x00;// square analog
   report.data[24] = 0x00;
   report.data[25] = 0x00;
   report.data[26] = 0x00;
   report.data[27] = 0x00; // 03 ?
   report.data[28] = 0x00; // ef ?
   report.data[29] = 0x00; // 16 ?
   report.data[30] = 0x00;
   report.data[31] = 0x00;
   report.data[32] = 0x00;
   report.data[33] = 0x00;
   report.data[34] = 0x00;//Accel x 4
   report.data[35] = 0x00;//Accel x 3
   report.data[36] = 0x00;//Accel x 2                                                   
   report.data[37] = 0x00;//Accel x 1
   report.data[38] = 0x00;//Accel y 4                                       
   report.data[39] = 0x00;//Accel y 3
   report.data[40] = 0x00;//Accel y 2
   report.data[41] = 0x00;//Accel y 1
   report.data[42] = 0x00;//Accel z 4
   report.data[43] = 0x00;//Accel z 3
   report.data[44] = 0x00;//Accel z 2
   report.data[45] = 0x00;//Accel z 1
   report.data[46] = 0x00;
   report.data[47] = 0x00;
   report.data[48] = 0x00;
   
   report.length = 49; 
  
   return send(&report);
}

bool USBJoystick::throttle(int16_t t) {
     _t = t;
     return update();
}

bool USBJoystick::rudder(int16_t r) {
     _r = r;
     return update();
}

bool USBJoystick::move(int16_t x, int16_t y) {
     _x = x;
     _y = y;
     return update();
}

bool USBJoystick::button(uint8_t button) {
     _button = button;
     return update();
}

bool USBJoystick::hat(uint8_t hat) {
     _hat = hat;
     return update();
}


void USBJoystick::_init() {

   _t = -127;
   _r = -127;    
   _x = 0;                       
   _y = 0;     
   _button = 0x0f;
   _hat = 0x00;              
}


uint8_t * USBJoystick::reportDesc() {    
         static uint8_t reportDescriptor[] = {
        
0x05, 0x01,        // Usage Page (Generic Desktop Ctrls)
0x09, 0x04,        // Usage (Joystick)
0xA1, 0x01,        // Collection (Physical)
0xA1, 0x02,        //   Collection (Application)
0x85, 0x01,        //     Report ID (1)
0x75, 0x08,        //     Report Size (8)
0x95, 0x01,        //     Report Count (1)        //byte 00
0x15, 0x00,        //     Logical Minimum (0)
0x26, 0xFF, 0x00,  //     Logical Maximum (255)
0x81, 0x03,        //     Input (Const,Var,Abs,No Wrap,Linear,Preferred State,No Null Position)
                   //     NOTE: reserved byte
0x75, 0x01,        //     Report Size (1)
0x95, 0x13,        //     Report Count (19)
0x15, 0x00,        //     Logical Minimum (0)
0x25, 0x01,        //     Logical Maximum (1)
0x35, 0x00,        //     Physical Minimum (0)
0x45, 0x01,        //     Physical Maximum (1)
0x05, 0x09,        //     Usage Page (Button)
0x19, 0x01,        //     Usage Minimum (0x01)
0x29, 0x13,        //     Usage Maximum (0x13)
0x81, 0x02,        //     Input (Data,Var,Abs,No Wrap,Linear,Preferred State,No Null Position)
0x75, 0x01,        //     Report Size (1)
0x95, 0x0D,        //     Report Count (13)      // byte 1 - 4
0x06, 0x00, 0xFF,  //     Usage Page (Vendor Defined 0xFF00)
0x81, 0x03,        //     Input (Const,Var,Abs,No Wrap,Linear,Preferred State,No Null Position)
                   //     NOTE: 32 bit integer, where 0:18 are buttons and 19:31 are reserved
0x15, 0x00,        //     Logical Minimum (0)
0x26, 0xFF, 0x00,  //     Logical Maximum (255)
0x05, 0x01,        //     Usage Page (Generic Desktop Ctrls)
0x09, 0x01,        //     Usage (Pointer)
0xA1, 0x00,        //     Collection (Undefined)
0x75, 0x08,        //       Report Size (8)
0x95, 0x04,        //       Report Count (4)
0x35, 0x00,        //       Physical Minimum (0)
0x46, 0xFF, 0x00,  //       Physical Maximum (255)
0x09, 0x30,        //       Usage (X)
0x09, 0x31,        //       Usage (Y)
0x09, 0x32,        //       Usage (Z)
0x09, 0x35,        //       Usage (Rz)
0x81, 0x02,        //       Input (Data,Var,Abs,No Wrap,Linear,Preferred State,No Null Position)
                   //       NOTE: four joysticks
0xC0,              //     End Collection
0x05, 0x01,        //     Usage Page (Generic Desktop Ctrls)
0x75, 0x08,        //     Report Size (8)
0x95, 0x27,        //     Report Count (39)
0x09, 0x01,        //     Usage (Pointer)
0x81, 0x02,        //     Input (Data,Var,Abs,No Wrap,Linear,Preferred State,No Null Position)
//0xC0,              // End Collection
//0xC0              // End Collection

0x75, 0x08,        //     Report Size (8)
0x95, 0x30,        //     Report Count (48)
0x09, 0x01,        //     Usage (Pointer)
0x91, 0x02,        //     Output (Data,Var,Abs,No Wrap,Linear,Preferred State,No Null Position,Non-volatile)
0x75, 0x08,        //     Report Size (8)
0x95, 0x30,        //     Report Count (48)
0x09, 0x01,        //     Usage (Pointer)
0xB1, 0x02,        //     Feature (Data,Var,Abs,No Wrap,Linear,Preferred State,No Null Position,Non-volatile)
0xC0,              //   End Collection
0xA1, 0x02,        //   Collection (Application)
0x85, 0x02,        //     Report ID (2)
0x75, 0x08,        //     Report Size (8)
0x95, 0x30,        //     Report Count (48)
0x09, 0x01,        //     Usage (Pointer)
0xB1, 0x02,        //     Feature (Data,Var,Abs,No Wrap,Linear,Preferred State,No Null Position,Non-volatile)
0xC0,              //   End Collection
0xA1, 0x02,        //   Collection (Application)
0x85, 0xEE,        //     Report ID (238)
0x75, 0x08,        //     Report Size (8)
0x95, 0x30,        //     Report Count (48)
0x09, 0x01,        //     Usage (Pointer)
0xB1, 0x02,        //     Feature (Data,Var,Abs,No Wrap,Linear,Preferred State,No Null Position,Non-volatile)
0xC0,              //   End Collection
0xA1, 0x02,        //   Collection (Application)
0x85, 0xEF,        //     Report ID (239)
0x75, 0x08,        //     Report Size (8)
0x95, 0x30,        //     Report Count (48)
0x09, 0x01,        //     Usage (Pointer)
0xB1, 0x02,        //     Feature (Data,Var,Abs,No Wrap,Linear,Preferred State,No Null Position,Non-volatile)
0xC0,              //   End Collection
0xC0,              // End Collection

// 148 bytes

        };

      reportLength = sizeof(reportDescriptor);
      return reportDescriptor;
}


