#include "mbed.h"
#include "RTC.h"

Ticker reading_i2c;

DigitalOut myled1(LED1);

DigitalOut myled2(LED2);

DigitalOut myled3(LED3);

DigitalOut myled4(LED4);


I2C i2c(p9, p10);
I2C i2c1(p28, p27);
 
const int addr = 0x90;
Serial pc(USBTX, USBRX);
int x;

void read_i2c ()
{
    x = 0;
}


void ledFunction( void )
{
    if (myled3 == 0)
        myled3 = 1;
    else myled3 = 0;
    //RTC::detach(RTC::Second);
    time_t seconds = time(NULL);
    printf("\n%s\n", ctime(&seconds));
}
 
int main() {
    reading_i2c.attach(&read_i2c, 0.1);

    set_time(1256729737);
    tm t = RTC::getDefaultTM();
    RTC::attach(&ledFunction, RTC::Second);

    int iI2Cfreq = 100000; // bus frequency in Hz
    i2c.frequency (iI2Cfreq); //set I2C frequency
    i2c1.frequency (iI2Cfreq); //set I2C frequency
    pc.baud(115200);

    int i,j;
    float z;
    char cRegister[1];
    char cData[2];
    char cData1[2];
    cRegister[0] = 0x0E;
    cData[0] = 0x00;
    cData[1] = 0x00;
    cData1[0] = 0x00;
    cData1[1] = 0x00;
    while (1) {
        if (x == 0)
        {
            i2c.write(addr, cRegister, 1);
            i2c.read(addr, cData, 2);
            i2c1.write(addr, cRegister, 1);
            i2c1.read(addr, cData1, 2);
            i = 256*(int)cData1[0]+(int)cData1[1];
            j = 256*(int)cData[0] + (int)cData[1];
            z = j;
            z = 100 - ((j - i)/z * 100);
            printf("Regulador %X %X \t ACQUAPLUS %X %X \t Eficiencia %f%%\n", cData[0], cData[1], cData1[0], cData1[1], z);
            x = 1;
        }
    }
}