#ifndef MOTOR_DRIVER_H
#define MOTOR_DRIVER_H

#include "mbed.h"


enum DIRECTION_NUMBER{
	CCW,
	CW,
	ALL,
	DIRECTION_NUMBER,
};

class MotorDriver{
    public:
        MotorDriver(PinName direction,PinName pwm);
		
		void drive(float v);
        void setup(float frequency , float low_limit, float up_limit);
        void gain(float cwgain_, float ccwgain_,float rate_);
        
        private:
        	
			float cwgain, ccwgain, rate;
			float upper_limit ;
			float lower_limit ;
        	float accelerated_duty;
            DigitalOut 	direction;
            PwmOut 		pwm; 
};


#endif



