#include "motor_driver.h"

MotorDriver::MotorDriver(PinName direction,PinName pwm) : direction(direction), pwm(pwm){}

void MotorDriver::drive(float v){
    float output;
    
    output = fabs(v);
    
    if(v > 0.0) {
        direction  = CW;
    } else {
        direction  = CCW; 
    }
    
    if(output <= lower_limit) {
        output = 0.0; 
    } else if(output >= upper_limit) {
        output = upper_limit; 
    } 

    //pwm = output;
    
    if(v >= 0.0f){
        pwm = output * cwgain  * rate;
    } else {
        pwm = output * ccwgain * rate;
    }
}


void MotorDriver::setup(float frequency , float low_limit, float up_limit) 
{
    gain(1.0, 1.0, 1.0);
    pwm.period(1/frequency);
    lower_limit = low_limit;
    upper_limit = up_limit;
}

void MotorDriver::gain(float cwgain_, float ccwgain_,float rate_){
    cwgain  = cwgain_;
    ccwgain = ccwgain_;
    rate    = rate_;    
}

