#include "mbed.h"
#include "motor_driver.h"

/*--------------*/
//Duty設定（0.0~1.0で設定してください）

//強いほう（andまっすぐ進んでる時）のモーターの出力
const float STRONG_DUTY = 0.35;

//弱いほうのモーターの出力
const float WEAK_DUTY = 0.15;

/*--------------*/
enum ROBOT_STATE_ENUM{
    LEARNED_TO_LEFT,
    LEARNED_TO_RIGHT,
    NO_LEARNED,
    ROBOT_STATE_NUMBER,
};

enum DIR_ENUM{
    LEFT,
    RIGHT,
    DIR_NUMBER,
};

int pause_state = 0;

InterruptIn userButton(USER_BUTTON);
Serial pc(USBTX,USBRX,230400);
//PwmOut mypwm(D5);  //construct mypwm (pin=PWM_OUT=PB3)78
DigitalOut myled(LED1); //set LED1 brink

MotorDriver motor[DIR_NUMBER] = {
    MotorDriver(D2,D5),
    MotorDriver(D3,D6),
};

AnalogIn photoReflector[DIR_NUMBER] ={
    AnalogIn(A0),
    AnalogIn(A1),
};

Ticker timer;

const float SENSOR_VOLTAGE_THRESHOULD[DIR_NUMBER] = {
    0.5,
    0.5
};

void timerProcessing(void);
void buttonInterrupt(void);
int getLearnedState(int left_sensor_state, int right_sensor_state);


int main(){
    int i;
    userButton.fall(&buttonInterrupt);
    for(int i=0;i<DIR_NUMBER; i++){
        motor[i].setup(20000,0.0,1.0);
    }
    timer.attach(&timerProcessing,0.01);
    
    //pc.printf("init\r\n");
    while (1){
    } 
}


void timerProcessing(void){
    int photo_reflector_state[DIRECTION_NUMBER];
    int robot_learned_state;
    float motor_vector[DIR_NUMBER];
    
    //フォトリフレクタの白黒検知
    for(int i=LEFT; i<DIR_NUMBER; i++){
        if(photoReflector[i].read() < SENSOR_VOLTAGE_THRESHOULD[i]){
            photo_reflector_state[i] = 1;
        } else { 
            photo_reflector_state[i] = 0;
        }
        pc.printf("sensor %d %f\t",i,photoReflector[i].read());
    }
    
    //ロボットの傾きの状態検知＆表示＆duty決定
    robot_learned_state = getLearnedState(photo_reflector_state[LEFT],photo_reflector_state[RIGHT]);
    
    pc.printf("ROBOT STATE:");
    switch(robot_learned_state){
        case NO_LEARNED:
            pc.printf("STRAIGHT\r\n");
            motor_vector[LEFT] = STRONG_DUTY;
            motor_vector[RIGHT] = STRONG_DUTY;
            break;
        case LEARNED_TO_LEFT:
            motor_vector[LEFT] = STRONG_DUTY;
            motor_vector[RIGHT] = WEAK_DUTY;
            pc.printf("Learned right\r\n");
            break;
        case LEARNED_TO_RIGHT:
            motor_vector[LEFT] = WEAK_DUTY;
            motor_vector[RIGHT] = STRONG_DUTY;
            pc.printf("Learned left\r\n");
            break;
        default:
            break;
    }
    
    for(int i=LEFT; i<=RIGHT; i++){
        if(!pause_state){
            motor[i].drive(motor_vector[i]);
        } else {
            motor[i].drive(0.0);
        } 
    }
}

int getLearnedState(int left_sensor_state, int right_sensor_state){

    if(left_sensor_state & right_sensor_state){
        return NO_LEARNED;
    } else if(left_sensor_state){ 
        return LEARNED_TO_RIGHT;
    } else if(right_sensor_state){
        return LEARNED_TO_LEFT;
    } else {
        return NO_LEARNED;
    }
}

void buttonInterrupt(void){
    pause_state = !pause_state;
}