#ifndef __NRF24L01P_H__
#define __NRF24L01P_H__

#include "mbed.h"

#define TX  1
#define RX  2

#define RX_DR   6  
#define TX_DS   5
#define MAX_RT  4 
#define TX_FULL 0  


#define NRF_READ_REG    0x00    // ¶Á¼Ä´æÆ÷Ö¸Áî
#define NRF_WRITE_REG   0x20    // Ð´¼Ä´æÆ÷Ö¸Áî
#define ACTIVATE        0x50    // follow with 0x73 to activate feature register
#define R_RX_PL_WID     0x60    // ¶Á½ÓÊÕ»º³åÇøµÄ³¤¶È
#define RD_RX_PLOAD     0x61    // ¶ÁÈ¡½ÓÊÕÊý¾ÝÖ¸Áî
#define WR_TX_PLOAD     0xA0    // Ð´´ý·¢Êý¾ÝÖ¸Áî
#define W_ACK_PAYLOAD   0xA8    // Used in RX mode.
#define FLUSH_TX        0xE1    // ³åÏ´·¢ËÍ FIFOÖ¸Áî
#define FLUSH_RX        0xE2    // ³åÏ´½ÓÊÕ FIFOÖ¸Áî
#define REUSE_TX_PL     0xE3    // ¶¨ÒåÖØ¸´×°ÔØÊý¾ÝÖ¸Áî
#define NOP             0xFF    // ±£Áô

#define CONFIG          0x00    // ÅäÖÃÊÕ·¢×´Ì¬£¬CRCÐ£ÑéÄ£Ê½ÒÔ¼°ÊÕ·¢×´Ì¬ÏìÓ¦·½Ê½
#define EN_AA           0x01    // ×Ô¶¯Ó¦´ð¹¦ÄÜÉèÖÃ
#define EN_RXADDR       0x02    // ¿ÉÓÃÐÅµÀÉèÖÃ
#define SETUP_AW        0x03    // ÊÕ·¢µØÖ·¿í¶ÈÉèÖÃ
#define SETUP_RETR      0x04    // ×Ô¶¯ÖØ·¢¹¦ÄÜÉèÖÃ
#define RF_CH           0x05    // ¹¤×÷ÆµÂÊÉèÖÃ
#define RF_SETUP        0x06    // ·¢ÉäËÙÂÊ¡¢¹¦ºÄ¹¦ÄÜÉèÖÃ
#define NRFRegSTATUS    0x07    // ×´Ì¬¼Ä´æÆ÷
#define OBSERVE_TX      0x08    // ·¢ËÍ¼à²â¹¦ÄÜ
#define CD              0x09    // µØÖ·¼ì²â           
#define RX_ADDR_P0      0x0A    // ÆµµÀ0½ÓÊÕÊý¾ÝµØÖ·
#define RX_ADDR_P1      0x0B    // ÆµµÀ1½ÓÊÕÊý¾ÝµØÖ·
#define RX_ADDR_P2      0x0C    // ÆµµÀ2½ÓÊÕÊý¾ÝµØÖ·
#define RX_ADDR_P3      0x0D    // ÆµµÀ3½ÓÊÕÊý¾ÝµØÖ·
#define RX_ADDR_P4      0x0E    // ÆµµÀ4½ÓÊÕÊý¾ÝµØÖ·
#define RX_ADDR_P5      0x0F    // ÆµµÀ5½ÓÊÕÊý¾ÝµØÖ·
#define TX_ADDR         0x10    // ·¢ËÍµØÖ·¼Ä´æÆ÷
#define RX_PW_P0        0x11    // ½ÓÊÕÆµµÀ0½ÓÊÕÊý¾Ý³¤¶È
#define RX_PW_P1        0x12    // ½ÓÊÕÆµµÀ1½ÓÊÕÊý¾Ý³¤¶È
#define RX_PW_P2        0x13    // ½ÓÊÕÆµµÀ2½ÓÊÕÊý¾Ý³¤¶È
#define RX_PW_P3        0x14    // ½ÓÊÕÆµµÀ3½ÓÊÕÊý¾Ý³¤¶È
#define RX_PW_P4        0x15    // ½ÓÊÕÆµµÀ4½ÓÊÕÊý¾Ý³¤¶È
#define RX_PW_P5        0x16    // ½ÓÊÕÆµµÀ5½ÓÊÕÊý¾Ý³¤¶È
#define FIFO_STATUS     0x17    // FIFOÕ»ÈëÕ»³ö×´Ì¬¼Ä´æÆ÷ÉèÖÃ

#define DYNPD           0x1C    // per pipe DPL control 
#define FEATURE         0x1D    // ¡°Feature¡± register address 



extern  uint8_t NRF24L01_RXDATA[32];
extern  uint8_t NRF24L01_TXDATA[32];

class nRF24L01P {

public:

    nRF24L01P(PinName mosi, PinName miso, PinName sck, PinName csn, PinName ce, PinName irq = NC);


    
    uint8_t NRF_Read_Reg(uint8_t reg);
    uint8_t NRF_Write_Reg(uint8_t reg, uint8_t value);
    uint8_t NRF_Read_Buff(uint8_t reg, uint8_t *pBuf, uint8_t uchars);
    uint8_t NRF_Write_Buf(uint8_t reg, uint8_t *pBuf, uint8_t uchars);
    
    void NRF24L01_Set_TX(void);
    void NRF24L01_Set_RX(void);
    
    void NRF24L01_Check(void);
    void NRF24L01_Init(uint8_t Chanal,uint8_t Mode);
    void NRF_Send_TX(uint8_t * tx_buf, uint8_t len);
    void NRF_Send_TX(int * tx_buf, uint8_t len);
    void NRF24L01_IRQ(void);

    void setRxAddress(int RxAdd);
    void setTxAddress(int TxAdd);

    void Nrf_Connect(int* data);
    void NRF24L01_Analyse(int* data);
    
    SPI         spi_;
    DigitalOut  nCS_;
    DigitalOut  ce_;
    DigitalOut  check_led;
    InterruptIn nIRQ_;
};

#endif
