#include "nRF24L01P.h"


uint8_t NRF24L01_RXDATA[32];
uint8_t NRF24L01_TXDATA[32];
uint8_t TX_ADDRESS[5]= {0x00,0x00,0x00,0x00,0x08};
uint8_t RX_ADDRESS[5]= {0x00,0x00,0x00,0x00,0x08};
int Nrf_Erro=0;
int ledtick;


void nRF24L01P::setRxAddress(int RxAdd)
{
	RX_ADDRESS[4]=RxAdd&0xFF;
}
void nRF24L01P::setTxAddress(int TxAdd)
{
	TX_ADDRESS[4]=TxAdd&0xFF;
}

uint8_t nRF24L01P::NRF_Read_Reg(uint8_t reg)
{
	uint8_t reg_val;
	nCS_=0;
	spi_.write(reg);
	reg_val = spi_.write(0);
	nCS_=1;
    return 	reg_val;

}	
uint8_t nRF24L01P::NRF_Write_Reg(uint8_t reg, uint8_t value)
{
	uint8_t status;
	nCS_=0;
	status = spi_.write(reg);
	spi_.write(value);
	nCS_=1;
	return 	status;
}
uint8_t nRF24L01P::NRF_Read_Buff(uint8_t reg, uint8_t *pBuf, uint8_t uchars)
{
	uint8_t i;
	uint8_t status;
	nCS_=0;
	status = spi_.write(reg);
	for(i=0; i<uchars; i++)
	{
		pBuf[i] = spi_.write(0);
	}
	nCS_=1;
    return 	status;
}
uint8_t nRF24L01P::NRF_Write_Buf(uint8_t reg, uint8_t *pBuf, uint8_t uchars)
{
	uint8_t i;
	uint8_t status;
	nCS_=0;
	status = spi_.write(reg);
	for(i=0; i<uchars; i++)
	{
		spi_.write(pBuf[i]);
	}
	nCS_=1;
    return 	status;	
}
void nRF24L01P::NRF24L01_Set_TX(void)
{
	ce_=0;
	NRF_Write_Reg(NRF_WRITE_REG + CONFIG,0x0E);
	ce_=1;
}
void nRF24L01P::NRF24L01_Set_RX(void)
{
	ce_=0;
	NRF_Write_Reg(NRF_WRITE_REG + CONFIG,0x0F);//½ÓÊÕ
	ce_=1;
}
void nRF24L01P::NRF_Send_TX(uint8_t * tx_buf, uint8_t len)
{	
	NRF24L01_Set_TX();
	ce_=0;
	NRF_Write_Buf(WR_TX_PLOAD, tx_buf, len);
	ce_=1;
	wait_us(10);
	ledtick++;
	if(ledtick>=50)
	{
		check_led=!check_led;
		ledtick=0;
	}
}
void nRF24L01P::NRF_Send_TX(int * tx_buf, uint8_t len)
{
	uint8_t i;
	uint8_t tx_buff[32];
	for(i=0;i<len;i++)
		tx_buff[i]=tx_buf[i]&0xFF;
	NRF24L01_Set_TX();
	ce_=0;
	NRF_Write_Buf(WR_TX_PLOAD, tx_buff, len);
	ce_=1;
	wait_us(10);
	ledtick++;
	if(ledtick>=50)
	{
		check_led=!check_led;
		ledtick=0;
	}
}
nRF24L01P::nRF24L01P(PinName mosi, 
                     PinName miso, 
                     PinName sck, 
                     PinName csn,
                     PinName ce,
                     PinName irq):spi_(mosi,miso,sck),nCS_(csn),ce_(ce),nIRQ_(irq),check_led(PC_13)
{
    nCS_ = 1;
    
    spi_.frequency(9000000); 
    spi_.format(8,0); 
    wait_us(4);    // Wait for Power-on reset
}


void nRF24L01P::NRF24L01_Check(void)
{
	uint8_t buf[5]; 
	uint8_t i; 
	NRF_Write_Buf(NRF_WRITE_REG+TX_ADDR,TX_ADDRESS,5); 
	NRF_Read_Buff(TX_ADDR,buf,5); 
	for(i=0;i<5;i++) 
	{ 
		if(buf[i]!=TX_ADDRESS[i]) 
			break; 
	} 
	
	if(i==5)
	{
		uint8_t ledt;
		for(ledt=0;ledt<5;ledt++)
		{
			check_led=0;
			wait_ms(100);
			check_led=1;
			wait_ms(100);
		}
	}
	else
	{
		uint8_t ledt;
		for(ledt=0;ledt<2;ledt++)
		{
			check_led=0;
			wait_ms(500);
			check_led=1;
			wait_ms(500);
		}
	}
}
void nRF24L01P::NRF24L01_Init(uint8_t Chanal,uint8_t Mode)
{
//	init_time++;
//	if(init_time>=3)
//		return;
	ce_=0;
	ledtick=0;
	NRF_Write_Reg(FLUSH_TX,0xff);
	NRF_Write_Reg(FLUSH_RX,0xff);
	NRF_Write_Buf(NRF_WRITE_REG + TX_ADDR,   TX_ADDRESS,5);
	NRF_Write_Buf(NRF_WRITE_REG + RX_ADDR_P0,RX_ADDRESS,5);	

	NRF_Write_Reg(NRF_WRITE_REG + EN_AA,     0x01);
	NRF_Write_Reg(NRF_WRITE_REG + EN_RXADDR, 0x01);
	NRF_Write_Reg(NRF_WRITE_REG + SETUP_RETR,0x1a);	
	NRF_Write_Reg(NRF_WRITE_REG + RF_CH,   Chanal);
	NRF_Write_Reg(NRF_WRITE_REG + RX_PW_P0,    32);
	NRF_Write_Reg(NRF_WRITE_REG + RF_SETUP,  0x0f);
	
	if(Mode==TX)
		NRF_Write_Reg(NRF_WRITE_REG + CONFIG,0x0E);
	else if(Mode==RX)
		NRF_Write_Reg(NRF_WRITE_REG + CONFIG,0x0F);

	ce_=1;
}
void nRF24L01P::NRF24L01_IRQ(void)
{
	uint8_t status = NRF_Read_Reg(NRF_READ_REG + NRFRegSTATUS);
	
	if(status & (1<<RX_DR))//RX中断
	{
		uint8_t rx_len = NRF_Read_Reg(R_RX_PL_WID);
		if(rx_len==32)
		{
			NRF_Read_Buff(RD_RX_PLOAD,NRF24L01_RXDATA,rx_len);//读取FIFO
			Nrf_Erro = 0;
		}
		else
		{
			NRF_Write_Reg(FLUSH_RX,0xff);//清空RX缓存
		}
	}
	if(status & (1<<MAX_RT))//达到最大重发次数
	{
		if(status & (1<<TX_FULL))//TX FIFO 溢出
		{
			NRF_Write_Reg(FLUSH_TX,0xff);//清空发送缓存
		}
	}
	NRF24L01_Set_RX();
	NRF_Write_Reg(NRF_WRITE_REG + NRFRegSTATUS, status);
}
void nRF24L01P::NRF24L01_Analyse(int* data)
{
	uint8_t i;
	for(i=0;i<32;i++)
		data[i]=NRF24L01_RXDATA[i];
}
void nRF24L01P::Nrf_Connect(int* data)//1KHZ
{
	Nrf_Erro ++;
	if(Nrf_Erro==1)
	{
		NRF24L01_Analyse(data);
	}
	if(Nrf_Erro%100==0)
	{	
		NRF24L01_IRQ();
	}
	if(Nrf_Erro>=1000)
	{	
		Nrf_Erro = 1;
		
	}
}
