#define HIGH 1
#define LOW 0
#include "mbed.h"
#include <string>
typedef bool boolean;
typedef std::string String;
#include "nRF24L01P.h"


int Yaw;
int Roll;
int Pitch;
int Power;
int rxdata[32];
int i;
int tickTime;

#define NRF24_TRANSFER_SIZE 32
nRF24L01P nrf24_PB_15(PB_15,PB_14,PB_13,PA_4,PB_2,PB_12);
Ticker tick510601;

DigitalOut led1(PB_4);
DigitalOut m1(PA_6);
DigitalOut m2(PA_7);
DigitalOut m3(PB_0);
DigitalOut m4(PB_1);

void nRF_Analysis()//此函数为NRF接收中断,里面可以用来处理数据
{
    nrf24_PB_15.NRF24L01_IRQ();
    Roll = rxdata[5] + rxdata[6]*256;
    Pitch = rxdata[7] + rxdata[8]*256;
    Yaw = rxdata[9] + rxdata[10]*256;
    Power = rxdata[11] + rxdata[12]*256;
}
void tick510601_handle()//定时器中断1kHz,函数Nrf_Connect()将接收数据传递到rxdata中(如果此时有数据)
{
    tickTime++;
    nrf24_PB_15.NRF24L01_IRQ();
    nrf24_PB_15.Nrf_Connect(rxdata);
}
int main() {
    tickTime=0;
    m1=0;m2=0;m3=0;m4=0;

    for (i = 0; i < 32; i++) {
        rxdata[i]=0;
    }

    nrf24_PB_15.setRxAddress(8ull);//设置接收地址
    nrf24_PB_15.setTxAddress(8ull);//设置发送地址
    nrf24_PB_15.NRF24L01_Init(40,RX);//初始化2.44GHz,模式为接收
    nrf24_PB_15.NRF24L01_Check();//检查NRF是否正常工作(PC_13的LED快闪5次为正常,慢闪2次为异常)
    nrf24_PB_15.nIRQ_.mode(PullDown);//输入中断引脚拉低
    nrf24_PB_15.nIRQ_.rise(&nRF_Analysis);//输入中断上升沿检测,绑定中断函数

    tick510601.attach(&tick510601_handle,0.001);
    


    while (true) {
        if(tickTime>50)
        {
            if(Roll<1300 && Pitch<1300 && Power<1300 && Yaw>1700)
            { 
                led1=!led1;
            }
            tickTime=0;
        }
    }

}