#include "mbed.h"

AnalogIn ain0(A0);
AnalogIn ain1(A1);

DigitalOut dout(D7);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
Serial pc(USBTX,USBRX);

Mutex stdio_mutex; // Para ver el efecto de mutex: poner wait_us a 1us y quitarlo o ponerlo, provoca errores en el envio muy frecuentemente.


Thread thread2;
Thread thread3;
Thread thread4;

Ticker parpadea1;
Ticker parpadea2;
Ticker parpadea3;


void parpadear1()
{
    led1=!led1;
}

void parpadear2()
{
    led2=!led2;
}

void parpadear3()
{
    led3=!led3;
}


void leds()
{
    while (1) {
        
        if(ain0 > 0.3f) {
            dout = 1;
        } else {
            dout = 0;
        }
        
        wait_ms(200);
    }
}





void parpadeo2()
{
    parpadea2.attach(&parpadear2, 0.5);
    while(1)
    {
        wait_us(500);
        stdio_mutex.lock();
        printf("%f \n", ain1.read()*3.3f);
        stdio_mutex.unlock();
    }
}



void parpadeo3()
{
    parpadea3.attach(&parpadear3, 0.25);
    while(1){wait_ms(300);}
}



int main(void)
{

    pc.baud(2000000);
    parpadea1.attach(&parpadear1, 1.0);
    thread2.start(parpadeo2);
    thread3.start(parpadeo3);
    thread4.start(leds);


    while (1) 
    {
        stdio_mutex.lock();
        printf("%f , ", ain0.read()*3.3f);
        stdio_mutex.unlock();
        wait_us(500);
    }
}




