// Final funcional para recoger todos los datos analogicos de la PCB. Precisa de un conversor externo i2c a
// analógico para el MLX90614, debido a la baja velocidad del puerto i2c.

#include "mbed.h"
#include "MLX90614.h"

// Asignación de pines para entradas analógicas, separación en dos ADCs
AnalogIn TempS1(PA_5);    // ADC1, lecturas de baja y media frecuencia
AnalogIn TempS2(PA_6);
AnalogIn TempS3(PA_7);
AnalogIn TempS4(PB_1);
AnalogIn TempA(PC_2);
AnalogIn Par(A1);
AnalogIn Vel(A2);
AnalogIn Volt(A0);
AnalogIn Corr1(A3); // ADC3, lecturas de alta frecuencia
AnalogIn Corr2(A4);
AnalogIn Corr3(A5);

AnalogIn TempAux1(PA_4);
AnalogIn TempAux2(PF_4);
int MTempAux1;
int MTempAux2;



// Comunicaciones con periféricos

SPI spi(PF_9,PF_8,PF_7); // SPI MOSI, MISO, SCLK
DigitalOut NSST(PF_2);
DigitalOut NSSW(PE_6);
DigitalOut NSSV(PC_8);
DigitalOut NSSC(PE_3);

I2C i2c(D14, D15); // Asignación de pines I2C para el sensor IR de temperatura: I2C_SDA, I2C_SCL 
MLX90614 mlx90614(&i2c);    // Inicialización del sensor infrarrojo de temperatura
int select; // 0 = object temp, 1 = ambient temp, no funciona con 0


// Declaración de variables para guardar las mediciones
float buff;     
int MTempS1;        
int MTempS2;
int MTempS3;
int MTempS4;
int MTempA;
int MTempR;
int MPar;
int MVel;
int MVolt;
int MCorr1;
int MCorr2;
int MCorr3;

char C1;
char C2;


EventQueue queue(64 * EVENTS_EVENT_SIZE);   // Lista de eventos para distribuir a threads

Serial pc(USBTX,USBRX);                     // Inicialización del puerto serie al PC

Thread thread1;                             // Inicialización de multi-threading
Thread thread2;
Thread thread3;

Ticker ISREnvio;                           // Inicialización de interrupciones
Ticker ISRTemperaturas;
Ticker ISRVI;

void Envio();                               // Declaración de subrutinas de interrupciones
void Temperaturas();
void VI();


// ENCODER

InterruptIn encoder(D8);

Timer tiempo;
float aux1;
int aux2;
int cambio;

void subida();


void subida()        // Envío de datos por puerto serie al PC
{ 

        
        if (cambio==0) 
            {
                cambio=1;
                tiempo.start();
            }
                
        else 
            {
                cambio=0;
                tiempo.stop();
                aux1 = tiempo.read();
                tiempo.reset();
            }
        
}




// FINAL ENCODER



void Envio()        // Envío de datos por puerto serie al PC
{ 

        printf("%f %i %i %i %i %i\n", // Cambiar escalado  %i %i %i %i %i
             aux1*1000000, MTempS4, MVolt, MCorr1, MCorr2, MCorr3); 
//
}

void Temperaturas()     // Lectura de temperaturas (NTCs estátor y ambiente + IR rotor)
{        

            //MTempS1=TempS1*4096; // Escalar con el circuito
            //MTempS2=TempS2*4096;
            //MTempS3=TempS3*4096;
            //MTempS4=TempS4*4096;
            //MTempA=TempA*4096;
            // MTempS1 = 292.4*pow(buff,3) - 382.46*pow(buff,2) + 282.26*buff - 13.152; 
            
            buff=TempS1; 
            MTempS1 = 2924*pow(buff,3) - 3825*pow(buff,2) + 2823*buff - 131;    
            buff=TempS2; 
            MTempS2 = 2924*pow(buff,3) - 3825*pow(buff,2) + 2823*buff - 131;  
            buff=TempS3; 
            MTempS3 = 2924*pow(buff,3) - 3825*pow(buff,2) + 2823*buff - 131;  
            buff=TempS4; 
            MTempS4 = 2924*pow(buff,3) - 3825*pow(buff,2) + 2823*buff - 131;  
            buff=TempA; 
            MTempA = 2924*pow(buff,3) - 3825*pow(buff,2) + 2823*buff - 131;  
            
            buff=TempAux1; 
            MTempAux1 = 2924*pow(buff,3) - 3825*pow(buff,2) + 2823*buff - 131;  
            buff=TempAux2; 
            MTempAux2 = 2924*pow(buff,3) - 3825*pow(buff,2) + 2823*buff - 131; 
             
                     
            //MTempR=mlx90614.read_temp(1)*10;   // Lectura del IR
           
}

    
void VI()     // Lectura de I en 3 fases, V en una fase
{        

            MCorr1=Corr1*4096;   // Escalar con el circuito
            MCorr2=Corr2*4096;
            MCorr3=Corr3*4096;
 
            buff=TempS4; 
            MTempS4 = 2924*pow(buff,3) - 3825*pow(buff,2) + 2823*buff - 131;  
       
            MVolt=Volt*4096; // Escalar con el circuito  
            
            if((tiempo.read()>1)||(aux1>1)) aux1=0;
            if(tiempo.read()>1) 
                {
                    tiempo.stop();
                    tiempo.reset();
                }
            
             
}    

int main(void)   // Thread 0
{
    //MTempR=mlx90614.read_temp(1);
    pc.baud(2000000);   // Baudrate a 2Mbauds
    spi.format(16,3);   // 16 bits de información, modo 3 (rising edge, lógica inversa)
    spi.frequency(1000000);     // 1MHz   
    printf("Introduzca ganancias:\n");
    
    NSSC=1;   
    NSST=1;
    NSSW=1;
    NSSV=1;
    
    encoder.rise(&subida);  // attach the address of the flip function to the rising edge
    //encoder.fall(&bajada);  // attach the address of the flip function to the rising edge
    
    
    // Asignación de interrupciones y periodos de muestreo (en segundos)
    
    ISREnvio.attach(queue.event(Envio), 0.0004);             
    //ISRTemperaturas.attach(queue.event(Temperaturas), 0.0005);
    ISRVI.attach(queue.event(VI), 0.0004);      
            
    thread1.start(callback(&queue, &EventQueue::dispatch_forever));     // Apertura de threads
    thread2.start(callback(&queue, &EventQueue::dispatch_forever));
    //thread3.start(callback(&queue, &EventQueue::dispatch_forever)); 
      
    while (1)   // Thread 0 en espera indefinida
    {
        wait(10);
    }
}

// NOTA: Se utiliza multithreading en lugar de interrupciones en thread0 ya que el uso de funciones
// bloqueantes (ADC, puerto serie) en una interrupción común puede causar problemas.
// Prueba de que el periodo de muestreo se cumple: Si no se cumpliera el periodo de muestreo más exigente,
// daría un error deoverflow del EventQueue

