#include "mbed.h"
#include "USBHostKeyboard.h"
#include "SDFileSystem.h"

//キーボード取得データをTX１、RX１からシリアル通信で送信させる
//SDカードに入力したデータを保存
//保存形式はcsv
//保存場所はディレクトリ「keylog」内の「log」ファイル

DigitalOut led(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

int i=0;

Timer t;    //タイマー宣言（繰り返しタイマー割り込み）

SDFileSystem sd(p5, p6, p7, p8, "sd");  //SDファイル用通信ポートの指定

//Serial pc1(p13, p14);                   //シリアル通信ポートの指定(tx1, rx1の順)
Serial pc(USBTX, USBRX);

void onKey(uint8_t key) {
    //pc1.printf("%c", key);      //1文字PCへ送信（TX1、RX1のシリアル通信）
    pc.printf("%c", key);
    i++;
    t.stop();           //キーを押すごとにタイマーストップ
                        //リセットしていないのでラップタイム計測状態となる
    FILE *fp;
    fp = fopen("/sd/keylog/log.csv", "a");      //「log.csv」ファイルを書き込み形式で開く
    fprintf(fp, "Key[%d], :,0x%x,:,%c,:,%0.2f\r\n", i, key, key, t.read());    //左から　入力順番：アスキーコード：入力した文字：経過時間　となる
    fclose(fp);       
    t.start();          //タイマースタート(一周後からはリスタート)    
}

void keyboard_task(void const *) {
    
    USBHostKeyboard keyboard;
    
    while(1) {
        while(!keyboard.connect())
            Thread::wait(500);

        keyboard.attach(onKey);
            
        while(keyboard.connected()) //キーボードが切れるまで待つ
            Thread::wait(500);
    }
}

int main(){
    mkdir("/sd/keylog", 0777);              //「keylog」ディレクトリ作成
    FILE *fp;
    fp = fopen("/sd/keylog/log.csv","w");   //「log.csv」ファイルを読込形式で開く
    fclose(fp);
    
    Thread keyboardTask(keyboard_task, NULL, osPriorityNormal, 256 * 4);
    while(1) {
        led=!led;
        Thread::wait(500);
    }
}

            //led2 = 1;           //キーを押すごとにled2を点灯
            //t.reset();          //キーボードを切断してタイマーリセット