#include "mbed.h"
#include "AMS_CCS811.h"
#include "BME680.h"
#include "serial.h"

using utils::SerialBuffer;
SerialBuffer USBserialComms(USBTX, USBRX);

int main() {

    USBserialComms.baud(115200);

    USBserialComms.printf("starting....\n\r");
    
    // I2C interface
    I2C i2c(PTC9, PTC8);
    //i2c.frequency(400000);
    
    // BME 680 interface
    BME680 bme(&i2c, false);
    
    // AMS CCS811 interface
    AMS_CCS811 ccs811(&i2c, PTA4);
    
    if (!bme.init()) {
        USBserialComms.printf("bme680 failed \n\r");
        return -1;
    }
    if (!ccs811.init()) {
        USBserialComms.printf("ccs811 failed \n\r");
        AMS_CCS811::ccs811_errors errs = ccs811.errors();
        USBserialComms.printf("Error count: %d\r", errs.count);
        for (int i = 0; i < errs.count; i++) {
            USBserialComms.printf("(%d) %s\r", errs.codes[i], ccs811.error_string(errs.codes[i]));
        }
        return -1;
    }
    USBserialComms.printf("sensors started \n\r");
    
    int ccsdata = ccs811.has_new_data();
    int bmedata = bme.isNewData(0);
    while (!bmedata || ccsdata != 1) {
        USBserialComms.printf("bme.isNewData: %d, ccs811.has_new_data: %d \n\r", bmedata, ccsdata);
        AMS_CCS811::ccs811_errors errs = ccs811.errors();
        USBserialComms.printf("Error count: %d\r", errs.count);
        for (int i = 0; i < errs.count; i++) {
            USBserialComms.printf("(%d) %s\r", errs.codes[i], ccs811.error_string(errs.codes[i]));
        }
        wait_ms(1000);
        ccsdata = ccs811.has_new_data();
        bmedata = bme.isNewData(0);
    }
    
    USBserialComms.printf("Finished \n\r");
}
