/*
 * WAV_Reader.h
 *
 *  Created on: 23 Feb 2017
 *      Author: ML15AAF
 */

#ifndef WAV_READER_H_
#define WAV_READER_H_

#include <mbed.h>

/* ERROR CONST */
/* FILE OPEN */
#define WAV_READER_FO_NULL_PTR      -1
#define WAV_READER_FO_NOT_RIFF      -2
#define WAV_READER_FO_NOT_WAV       -3
#define WAV_READER_FO_NO_FMT        -4
#define WAV_READER_FO_NO_DATA       -5
#define WAV_READER_FO_NO_DATA_FMT   -9

class WAV_Reader {

    public:

        struct Config {
                uint16_t format_tag;
                uint16_t channels;
                uint32_t samples_per_sec;
                uint32_t avg_bytes_per_sec;
                uint16_t block_align;
                uint16_t bits_per_sample;
                uint32_t data_pos;
                uint32_t data_length;
                uint32_t file_size;

                Config();
        };

        WAV_Reader();
        int open(FILE **filepp);
        int read(int buff[], int size, int len);
        void reset();
        void seek(int num, int start = -1);
        bool loop();
        void loop(bool enable);
        uint16_t channels();
        uint32_t samples_per_sec();
        uint32_t bytes_per_sec();
        uint16_t block_align();
        uint16_t bits_per_sample();
        uint32_t data_length();

    private:
        FILE ** fpp;
        int _current_pos;
        bool _loop;

        Config config;

        int read_bytes(FILE *fp, char* out, int len_to_read, int start_off = 0);
        bool check_bytes(FILE *fp, char* check, int len, int start = 0);
        uint32_t read_num(FILE *fp, int len, int start = 0);
        uint32_t get_num(char input[], int byte_count);
        int find_chunk(FILE *fp, char* check, int max_len, int start = 0);
        int move_read_position(int count, int start);
};

#endif /* WAV_READER_H_ */
