#include "serialBuffer.h"

SerialBuffer::SerialBuffer(PinName tx, PinName rx) : RawSerial(tx, rx), rx_buffer(512, "serial") {
    RawSerial::attach(callback(this, &SerialBuffer::rx_interrupt), Serial::RxIrq);
    return;
}

SerialBuffer::~SerialBuffer() {
    RawSerial::attach(NULL, RawSerial::RxIrq);
    return;
}

int SerialBuffer::readable() {
    return rx_buffer.count() > 0;
}

char SerialBuffer::getc() {
    RawSerial::attach(NULL, RawSerial::RxIrq);
    
    char nextChar = rx_buffer.pop();

    RawSerial::attach(callback(this, &SerialBuffer::rx_interrupt), Serial::RxIrq);
    
    return nextChar;
}

void SerialBuffer::rx_interrupt(void) {
    if(serial_readable(&_serial) && !rx_buffer.full()) {
        rx_buffer.push(serial_getc(&_serial));
    }

    return;   
}
