
template<class type>
LinearArray<type>::LinearArray(int size, char * name, bool forced) :
		_elem_count(0), _array_size(size), _front(0), _rear(-1), _forced(forced) {

	linear_array_info[linear_array_count] = new char[20];
	int sizeof_this = sizeof(type) * size;
	snprintf(linear_array_info[linear_array_count], 20, "%s:%d\n", name, sizeof_this);

	linear_array_count++;
	linear_array_memeory_used += sizeof_this;
	_array = new (std::nothrow) type[size];
}

template<class type>
LinearArray<type>::~LinearArray() {
	delete[] _array;
}

template<class type>
int LinearArray<type>::push(type item) {

	int ret = -1;
	bool room = _elem_count < _array_size;
	if (!room && _forced) {
		if (++_front == _array_size) _front = 0;
		_elem_count--;
		room = true;
	}
	if (room) {
		if (_rear == _array_size - 1) _rear = -1;
		_array[++_rear] = item;
		ret = _elem_count++;
	}

	return ret;
}

template<class type>
type& LinearArray<type>::pop() {

	static type defaultType;
	type item = defaultType;

	if (_elem_count > 0) {
		item = _array[_front++];
		if (_front == _array_size) _front = 0;
		_elem_count--;
	}

	return item;

}

template<class type>
bool LinearArray<type>::try_pop(type& item) {
	bool success = false;

	if (_elem_count > 0) {
		item = _array[_front++];
		if (_front == _array_size) _front = 0;
		_elem_count--;
		success = true;
	}

	return success;
}

template<class type>
type& LinearArray<type>::peek(int idx) {

	static type defaultType;
	type item = defaultType;

	if (idx <= _elem_count) {
		int real_loc = _front + idx;
		if (real_loc >= _array_size) {
			real_loc = real_loc - _array_size;
		}

		item = _array[real_loc];
	}

	return item;

}

template<class type>
int LinearArray<type>::size() {
	return _array_size;
}

template<class type>
int LinearArray<type>::count() {
	return _elem_count;
}

template<class type>
bool LinearArray<type>::full() {
	return _elem_count == _array_size;
}
