#ifndef LINEAR_ARRAY_H
#define LINEAR_ARRAY_H

#include "mbed.h"
#include "temp_const.h"


template<class type>
class LinearArray {
	public:
		LinearArray(int size, char * name, bool forced = false);
		~LinearArray();
		int push(type item);
		type& pop();
		bool try_pop(type& item);
		type& peek();
		type& peek(int idx);
		int size();
		bool empty();
		bool full();
		int count();
	private:
		type* _array;
		int _elem_count;
		int _array_size;
		int _front;
		int _rear;
		bool _forced;

};


#include "linearArray.hpp"

#endif /* LINEAR_ARRAY_H */
