#ifndef TERMINAL_H
#define TERMINAL_H

#include "mbed.h"

#define INPUT_BUFFER_MAX 32
#define NUM_COMMANDS_MAX 8



class CmdHandler
{
public:
    virtual ~CmdHandler() {}
    virtual void sendChar(char c) {}
};



class Terminal
{
public:
    Terminal(PinName tx = USBTX, PinName rx = USBRX, int baudrate = 460800);
    void addCommand(const char* cmdString, CmdHandler* (*fpointer)(Terminal*, const char*) );
    void terminateCmd();
    void write(const char* string);
    
protected:
    Serial serial;
    void receive();
    char inputBuffer[INPUT_BUFFER_MAX];
    CmdHandler* runningCmd;
    
    struct cmd
    {
        char cmdString[INPUT_BUFFER_MAX];
        int stringLength;
        CmdHandler* (*fpointer)(Terminal*, const char*);
        cmd() { stringLength = 0; }
    };
    
    cmd cmdList[NUM_COMMANDS_MAX];
    int numCommands;
};

#endif // TERMINAL_H