#ifndef SERVO_H
#define SERVO_H

#include "mbed.h"



class Servo
{
public:
    Servo(PinName pin, bool start = true);
    bool calibrate(unsigned int plus45, unsigned int minus45, float upperLimit, float lowerLimit);
    void write(float degrees);
    void writeWidth(unsigned int width);
    float read();
    int readWidth();
    void disable();
    void enable();
    void operator=(float degrees);
    operator float();
    operator int();
    
    unsigned int center;
    float usPerDegree;
    float upperLimit;
    float lowerLimit;
    
protected:
    static unsigned int numServos;
    static Servo *servos[];
    static const unsigned int period = 20000;
    static Ticker* refreshTicker;
    Timeout servoTimeout;
    unsigned int pulseWidth;
    DigitalOut signalPin;
    bool enabled;
    
    
    
    static void refresh();
    void timeout();
};

#endif // SERVO_H