#include "mbed.h"
#include "TFmini.h"

DigitalOut led1(LED1);
TFmini tfmini(PA_0, PA_1);
Serial pc(USBTX, USBRX, 230400);

// main() runs in its own thread in the OS
int main() {
    while (true) {
        led1 = !led1;
        pc.printf("distance<%5d cm> strength<%5d>\r\n", tfmini.getDistance(), tfmini.getDistance());
        if(tfmini.getDistance() < 700) {
            for(int i = 0; i < (int)tfmini.getDistance()/5; i++) {
                pc.printf("#");
            }
        }
        pc.printf("\r");
        wait(0.05);
    }
}

