#ifndef USRF_MB1310Library
#define USRF_MB1310Library

#include "mbed.h"

class USRF_MB1310
{
    private:
        AnalogIn* AnalogInput;
        DigitalOut* SerialOutput;
        Serial* SerialInput;
        float operatingvoltage;
        float unitfactor;
        float scalingfactor;
        float distance;
        
    public:
        USRF_MB1310(PinName, PinName, PinName);
            //analog input, serial output, serial input; specify NC if not used
        void setoperatingvoltage(float);
            //sets expected operating voltage of scaling functions;
            //user responsibility to ensure operating voltage between 3.3V and 5V;
            //default is 3.3V
        void selectunit(int);
            //argument sets unit scaling factor;
            //0 for cm, 1 for m, 2 for in, 3 for ft;
            //default is 0
        void requestserialquery();
            //this tells the device to prepare a serial reading;
            //must be done at least 99 ms before the query is read
        float query();
        float query(int);
            //get a reading from the device by the mode specified in the argument;
            //0 for analog, 1 for serial; requestserialquery() must be called at least
            //99ms before query(1) can be called, otherwise it will return 0;
            //overloaded so default no argument is an analog reading
        USRF_MB1310& operator =(float);
            //can be used for shorthand for unit selection or for setting non included units;
            //the output in cm will be multiplied by the assigned float;
            //ex: "USRF_MB1310object = 10 will convert units to mm
        operator float();
            //can be used as shorthand for taking an analog reading;
            //ex: "float reading = USRF_MB1310object;"
        //NOTE: STILL UNDER DEVELOPMENT, PLEASE TEST
};

#endif