#include "USRF_MB1310.h"

USRF_MB1310::USRF_MB1310(PinName an, PinName tx, PinName rx)
{
    if (an != NC)
    {
        AnalogInput = new AnalogIn(an);
    }
    if (tx != NC)
    {
        SerialOutput = new DigitalOut(tx);
    }
    if (rx != NC)
    {
        SerialInput = new Serial(NC, rx);
    }
    operatingvoltage = 3.3;
    unitfactor = 1;
    scalingfactor = 3.3 / 1000 * 1024 / operatingvoltage * unitfactor;//range, millivolts, device, units
        //set defaults
}

void USRF_MB1310::setoperatingvoltage(float input)
{
    operatingvoltage = input;
    scalingfactor = 3.3 / 1000 * 1024 / operatingvoltage * unitfactor;
}

void USRF_MB1310::selectunit(int unit)
{
    switch(unit)
    {
        case 0:
            unitfactor = 1;
            scalingfactor = 3.3 / 1000 * 1024 / operatingvoltage * unitfactor;
            break;
        case 1:
            unitfactor = 1 / 100;
            scalingfactor = 3.3 / 1000 * 1024 / operatingvoltage * unitfactor;
            break;
        case 2:
            unitfactor = 1 / 2.54;
            scalingfactor = 3.3 / 1000 * 1024 / operatingvoltage * unitfactor;
            break;
        case 3:
            unitfactor = 1 / 2.54 / 12;
            scalingfactor = 3.3 / 1000 * 1024 / operatingvoltage * unitfactor;
            break;
    }
}

void USRF_MB1310::requestserialquery()
{
    if (SerialOutput != 0)
    {
        SerialOutput->write(1);
        wait_us(50);
        SerialOutput->write(0);
    }
}
    //hold pin high for at least 20 us to signal a serial query

float USRF_MB1310::query()
{
    if (AnalogInput != 0)
    {
        distance = AnalogInput->read() * scalingfactor;
    }
    else if ((SerialInput != 0) && (SerialInput->readable()))
    {
        SerialInput->scanf("R%f\r", &distance);
        distance = distance * unitfactor;
    }
    else
    {
        distance = 0;
    }
    return distance;
}
float USRF_MB1310::query(int mode)
{
    switch (mode)
    {
        case 0:
            if (AnalogInput != 0)
            {
                distance = AnalogInput->read() * scalingfactor;
            }
            else
            {
                distance = 0;
            }
            break;
        case 1:
            if ((SerialInput != 0) && (SerialInput->readable()))
            {
                SerialInput->scanf("R%f\r", &distance);
                distance = distance * unitfactor;
            }
            else
            {
                distance = 0;
            }
            break;
    }
    return distance;
}

USRF_MB1310& USRF_MB1310::operator =(float assignment)
{
    unitfactor = assignment;
    *this = assignment;
    return *this;
}

USRF_MB1310::operator float()
{
    if (AnalogInput != 0)
    {
        distance = AnalogInput->read() * scalingfactor;
    }
    else if ((SerialInput != 0) && (SerialInput->readable()))
    {
        SerialInput->scanf("R%f\r", &distance);
        distance = distance * unitfactor;
    }
    else
    {
        distance = 0;
    }
    return distance;
}