#include "stdint.h"
#include "mbed.h"

class Servo : private PwmOut
{
    private:
        int period;
        int center;
        int maximum;
        int minimum;
        int position;
         
    public:
        Servo(PinName);
            //constructor sets defaults and starts servo with 0% duty cycle
        void setposition (int);
            //set normalized servo position (-255 to 255), default = 0
        void setperiod (int);
            //set the period in us, default = 20000
        void setcenter (int);
            //set center deflection pulse width in us, default = 1500
        void setmaximum (int);
            //set maximum deflection pulse width in us, default = 2400
        void setminimum (int);
            //set minimum deflection pulse width in us, default = 600
        Servo& operator =(int);
            //shorthand for setposition, ex: "ServoObj = 231;"
        operator int();
            //shorthand for position reading, ex: "check = ServoObj;"
        /*NOTE: setposition must be called before any changes to
        period, center, maximum, or minimum can take effect*/
};