#include "Servo.h"

Servo::Servo(PinName port) : PwmOut(port)
{
    period = 20000;
    maximum = 2400;
    minimum = 600;
    center = 1500;
    position = 0;
        //set default values
    pulsewidth_us(0);
    period_us(period);
}

void Servo::setposition(int input) 
{   
    position = input;
    if(position > 255)
    {
        position = 255;
    }
    else if (position < -255)
    {
        position = -255;
    }
        //saturate
    if(position >= 0)
    {
        pulsewidth_us(position * (maximum - center) / 255 + center);
    }
    else 
    {
        pulsewidth_us(position * (center - minimum) / 255 + center);
    }
        //set position normalized to 255
}

void Servo::setperiod(int input)
{
    period = input;
    period_us(period);
}

void Servo::setcenter(int input)
{
    center = input;
}

void Servo::setmaximum(int input) 
{
    maximum = input;
}

void Servo::setminimum(int input)
{
    minimum = input;
}

Servo& Servo::operator =(int assignment)
{
    Servo::setposition(assignment);
        //shorthand for setposition
    *this = assignment;
    return *this;
        //allow multiple assignment
}

Servo::operator int()
{
    int measurement = read() * period;
    if(measurement >= center)
    {
        return 255 * (measurement - center) / (maximum - center);
    }
    else 
    {
        return 255 * (measurement - position) / (center - minimum);
    }
}