#include "mbed.h"
#include "main.h"
#include <stdint.h>
#include <math.h>

/*
 * IO pins declaration
 */
AnalogIn Trq_raw(PC_1);

/*
 * Mbed Objects declaration
 */
Serial      pc(USBTX, USBRX, 115200);
CAN         can1(PB_8, PB_9, 1000000);              //1Mbps, contain critical torque command message
Ticker      ticker1;                                //100Hz task
CANMessage  can_msg_Rx;
CANMessage  can_msg_Tx;


//Timers
void timer1_interrupt(void)
{
    HSTick += 1;
    LSTick += 1;

if (HSTick > 9)             // 100Hz
{
    HST_EXFL = 1;
    HSTick = 0;
}
if (LSTick > 99)            // 10Hz
{
    LST_EXFL = 1;
    LSTick = 0;
}
}

int main()
{
    // Initializing
    printf("Motor_upper_control starts up\n");

    //Init CAN network
    CAN_init();                 // Note now in Gloable test mode only for testing 2019/11/17

    //attach IRQs after all other things are ready
    ticker1.attach_us(&timer1_interrupt, 1000);     //1 ms Systick
    while(1) {

        if(HST_EXFL) {
            HST_EXFL = false;
//            pc.printf("High speed says hi! \n");
            Tx_High_CAN1();
        }
        if(LST_EXFL) {
            LST_EXFL = false;
//            pc.printf("Low speed says hi! \n");
            printf("Torque read: %.1f ", float(Trq_raw));
            Tx_Low_CAN1();
        }
    }
}

void CAN_init(void)
{
    //Set CAN system
    SET_BIT(CAN1->MCR, CAN_MCR_ABOM);               // Enable auto reboot after bus off
//    can1.filter(Trq_send_ID,0xFFFF,CANStandard,0);    // ID filter listing mode
//    can1.filter(Id_cmd_ID,0xFFFF,CANStandard,1);
//    can1.filter(Iq_cmd_ID,0xFFFF,CANStandard,2);
//    can1.mode(CAN::GlobalTest);                     // Add only for testing 2019/11/13
    can1.attach(&Rx_CAN1, CAN::RxIrq);              // CAN1 Recieve Irq
}

void Rx_CAN1(void)
{
//    LED = 1;
    int16_t tmp;

    if(can1.read(can_msg_Rx)) {
//        switch(can_msg_Rx.id) {                                 //Filtered input message
            // Start of 100Hz msg
//            case Some_ID://1
//                //HSB from FL motor drive
//                Something1 = can_msg_Rx.data[6] & 0x03;             //Get DSM_STAT
//                tmp = can_msg_Rx.data[5] << 8 | can_msg_Rx.data[4];
//                Something2 = tmp*1.0f;
//                tmp = can_msg_Rx.data[3] << 8 | can_msg_Rx.data[2];
//                Something3 = tmp * 0.01f;
//                tmp = can_msg_Rx.data[1] << 8 | can_msg_Rx.data[0];
//                Something4 = tmp * 0.01f;
//                break;
//        }
    }
//    LED = 0;
}

void Tx_High_CAN1(void)     // 100 Hz
{
    int16_t tmp;
    tmp = (int16_t) (Id_cmd * 100.0f);
    temp_msg[0] = tmp;
    temp_msg[1] = tmp >> 8U;
    temp_msg[2] = 0U;
    tmp = (int16_t) (Iq_cmd * 100.0f);
    temp_msg[3] = tmp;
    temp_msg[4] = tmp >> 8U;
    temp_msg[5] = 0U;
    temp_msg[6] = 0U;
    temp_msg[7] = 0U;
    can_msg_Tx = CANMessage(Trq_send_ID,temp_msg,8,CANData,CANStandard);
    CANpendTX();
    can1.write(can_msg_Tx);
}

void Tx_Low_CAN1(void)     // 10 Hz
{
    int16_t tmp;
    tmp = (int16_t) (Trq_send * 100.0f);
    temp_msg[0] = tmp;
    temp_msg[1] = tmp >> 8U;
    temp_msg[2] = 0U;
    temp_msg[3] = 0U;
    temp_msg[4] = 0U;
    temp_msg[5] = 0U;
    temp_msg[6] = 0U;
    temp_msg[7] = 0U;
    can_msg_Tx = CANMessage(Trq_send_ID,temp_msg,8,CANData,CANStandard);
    CANpendTX();
    can1.write(can_msg_Tx);
}
void CANpendTX(void)
{
    //Pend till TX box has empty slot, timeout will generate error
    uint32_t timeout = 0;
    while(!(CAN1->TSR & CAN_TSR_TME_Msk)) {
        //Wait till non empty
        timeout += 1;
        if(timeout > 10000) {
            // Put some timeout error handler
            break;
        }
    }
}