#include "mbed.h"
#include "hcsr04.h"

Serial pc(PA_2, PA_15, 115200);

HCSR04  usensor(PA_8,PA_11);
AnalogOut Distance_out(A3);

unsigned int dist;
unsigned int time_us;
float dist_mm;
float dist_ratio;
float dist_ratio_last;
float dist_ratio_fil;
const float height_max = 300; //unit: mm
const float height_min = 50; //unit: mm

int main()
{
    while(1) {
        usensor.start();
        dist=usensor.get_dist_cm();
        time_us=usensor.get_pulse_us();
        dist_mm = 346.0f*time_us/2000.0f;
        
//        pc.printf("cm:%d\n",dist );
//        pc.printf("us:%d\n",time_us );
        pc.printf("%.3f\n\r",dist_mm );

        dist_ratio = (dist_mm - height_min)/(height_max - height_min);
        if (dist_ratio > 2.0f) {dist_ratio = dist_ratio_last;}
        dist_ratio_fil = (1.0f-0.03f)*dist_ratio_fil + 0.03f*dist_ratio;
        
        if (dist_ratio < 1.0f && dist_ratio > 0.0f) {
            Distance_out = dist_ratio;
        } else if (dist_ratio > 1.0f) {
            Distance_out = 1.0f;
        } else {
            Distance_out = 0.0f;
        }
        dist_ratio_last = dist_ratio;
//        pc.printf("%3.3f,%3.3f\n\r", dist_ratio, dist_ratio_fil );
    }
}