#include "mbed.h"

#define MCP9808_ADDR     (0x30) // MCP9808 base address 0x18<<1
#define MCP9808_REG_TEMP (0x05) // Temperature Register
#define MCP9808_REG_CONF (0x01) // Configuration Register
#define MCP9808_REG_CRIT (0x04) // Critical Temperature Register

// Uncomment to use file save
// LocalFileSystem local("local");               // Create the local filesystem under the name "local"

Serial pc(USBTX, USBRX);
I2C i2c(p9, p10);   // SDA, SCL on MCP9808
// Note MCP9808 also needs VCC (3.3 V) and GND

float TempValue;
float data[20];
char data_write[3], data_read[2];
int ii, status;
int main() {
    // Wake up
    data_write[0] = MCP9808_REG_CONF; // Register address
    data_write[1] = 0x00;  // Data MSB, b11-15 not used, b9-10 =>T_HYS=0, b8 => continuous conversions
    data_write[2] = 0x04;  // Data LSB,  Alert Off, Alert Disabled, Alert T>T_Crit, Alert active low, Alert interrupt
    status = i2c.write(MCP9808_ADDR, data_write, 3, 0); // address,data,length,repeat
    // address is chip addess
    // First byte of data has register address 
    // repeat true for multiple write when the chip autoincrements the address
    // MCP9808 does not do this, so we leave it at 0
      
    while(1){
        int i=0;
        // this loops takes 20 data points and then
        // appends those data points to a file
        // the file write will be mostly closed, so the mbed
        // file system will be available to a host computer
        // See warning below
        while(i<20){
        // Read temperature  
            data_write[0] = MCP9808_REG_TEMP;
            i2c.write(MCP9808_ADDR, data_write, 1, 1); // no stop
            i2c.read(MCP9808_ADDR, data_read, 2, 0);
            status = data_read[0] >> 5;  // Shift flags to b0-b2
            // 1 in flag means: T>T_crit(b2), T>T_Upper(b1), T<T_Lower(b0)
           // pc.printf("the status is %n",status);
            data_read[0] = data_read[0] & 0x1F;  // clear flag bits for temperature
            
            data[i] = (data_read[0] * 16) + (data_read[1] / 16.0); // combine two bytes
            // Display the flags, if you wish
            // pc.printf("Flags are %i \n\r",status);
            // This displays to the user
            pc.printf("%i Temperature is %3.1f\n\r",i,data[i]);
            i=i+1;
            wait(1);
        }
/*        
If the microcontroller program opens a file on the local drive, it will be marked as “removed” on the Host computer.
This means the PC will often display a message such as "insert a disk into drive" if you try to access it at this time;
this is normal, and stops both the mbed and the PC trying to access the disk at the same time.

The USB drive will only re-appear when all file handles are closed in your program, or the microcontroller program exits.
If a running program on the mbed does not exit or does not release it's open file handles, you will no longer be able to see the USB drive
when you plug the mbed into your PC.

To allow you to see the drive again (and load a new program), use the following procedure:

        Unplug the microcontroller
        Hold the reset button down
        While still holding the button, plug in the microcontroller. The mbed USB drive should appear.
        Keep holding the button until the new program is saved onto the USB drive.

*/
 // This section does the file ave
 /*
        FILE *fp = fopen("/local/out.txt", "a");  // Open "out.txt" on the local file system for writing
        for( ii = 0; ii < 20; ii++ ){
            fprintf(fp, "Temperature is %3.1f\r\n",data[ii]);
        }
        fclose(fp);
*/

    }
}
