#include "mbed.h"
#include "SerialRPCInterface.h"
#include "mbed_rpc.h"

Serial pc(USBTX, USBRX);

// Define some Digit outputs to address via Serial
RpcDigitalOut myled1(LED1,"myled1");
RpcDigitalOut myled2(LED2,"myled2");
RpcDigitalOut myled3(LED3,"myled3");
RpcDigitalOut myled4(LED4,"myled4");

// Define a function to address via Serial
void BCmult(Arguments *input, Reply *output);
RPCFunction rpcScale(&BCmult, "BCmult");
// This makes x and y global, so they can be changed in BCmult
int x,y;
// Define some variables to address via Serial
RPCVariable<int> rpcLights(&x, "x");
RPCVariable<int> rpcBanner(&y, "y");

void BCmult(Arguments *in, Reply *out) {
   //int x,y;
   char buffer[200];
    x = in->getArg<int>();
    y = in->getArg<int>();
    x = 2*x;
    y = 3*y;
    sprintf(buffer, "%i, %i\n", x, y );
    out->putData(buffer);
}
int main() {
    pc.printf("starting...");
    char buf[256], outbuf[256];
    while(1) {
      pc.gets(buf, 256);
      RPC::call(buf, outbuf); 
// Print the response
      pc.printf("%s\n", outbuf);
    }
}

