#include "mbed.h"
#include "EthernetNetIf.h"
#include "NTPClient.h"
#include "TextLCD.h"

/****************** Class Global Declartions **********************/
EthernetNetIf eth; 
NTPClient ntp;
TextLCD lcd(p5, p6, p7, p8, p9, p10);
InterruptIn statechange(p23);
InterruptIn plus(p22);
InterruptIn minus(p21);
Ticker ring;
BusOut led(LED1, LED2, LED3, LED4);
/******************************************************************/
/***************** Standard Global Declartions ********************/

int menu = 0;           // Holds the current menu information 
int timezone = 0;       // Timezone is configured as UTC + timezone - 12
bool alarmstate = false;// Determines whether the alarm is set or not
bool ringflag = false;  // Determines if alarm is ringing
bool snooze = false;    // True if the alarm has been turned off by a button
struct tm *cTime;       // Stucture that holds the current time
int ahour;              // Value that holds alarm hour
int amin;               // Value that holds alarm minute
/******************************************************************/
/*********************** Function Declartions *********************/
void print_lcd();
void print_time(int, int);
void print_menu();
void change_menu();
void button_press(int);
void push_plus();
void push_minus();
void alarm_ring();
void alarm_snooze();
void alarm_check();
/******************************************************************/