#include "mbed.h"

AnalogOut dac(PTE30);

Serial pc(USBTX,USBRX);

uint16_t dacIntValue = 0;

float dacValue = 0;
float dacVoltage = 0;

void rxInterrupt()
{

    switch(pc.getc()) {

        case 'a':
            
            if(dacValue>0.001){
                dacValue = dacValue - 0.001;                             
            }
            
            dacIntValue = (uint16_t)(4095*dacValue);

            break;

        case 's':
        
            if(dacValue<1){
                dacValue = dacValue + 0.001;                             
            }
            
            dacIntValue = (uint16_t)(4095*dacValue);

            break;
            
            case 'f':
            
            if(dacIntValue> 1){
                dacIntValue = dacIntValue - 1;                             
            }
            
            dacValue = dacIntValue/4095.0;
        
           
            break;
            
            
            case 'g':
            
            if(dacIntValue< 4095){
                dacIntValue = dacIntValue + 1;                             
            }
            
            dacValue = dacIntValue/4095.0;
            
            break;
            
            default: break;
    }
    
    dacVoltage = 3.3 * dacValue;
    
    dac.write(dacValue);
    
    
    pc.printf("DAC Value: %i, DAC Voltage: %.4f \r\n", dacIntValue, dacVoltage);

}

int main()
{

    pc.baud(115200);
    pc.attach(&rxInterrupt);

    while(1);
}
