#include "mbed.h"

AnalogIn LDR(A0);
Serial pc(USBTX,USBRX);

int main() {
    
    uint16_t adcValue;
    float voltage;
    
    
    pc.baud(115200);
    
    while(1) {
        
        adcValue = LDR.read_u16();
        
        voltage = adcValue *3.3 / 65535;
        
        pc.printf("ADC Value: %i, %.3f volts.\r\n", adcValue, voltage);
        
        wait(0.1);       
        
        
    }
}
